/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.math.BigDecimal;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class DebitColumn
extends FinancialTransactionColumn {
    public DebitColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        this.renderer = new BigDecimalTableCellRenderer();
        this.editor = new BigDecimalTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return BigDecimal.class;
    }

    @Override
    public String getColumnName() {
        return I18n._((String)"lima.ui.financialtransaction.debit", (Object[])new Object[0]);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = this.tableModel.getEntryAt(row);
        return entry.getDebit() ? entry.getAmount() : BigDecimal.ZERO;
    }

    @Override
    public boolean isCellEditable(int row) {
        return true;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        boolean update;
        Entry entry = this.tableModel.getEntryAt(row);
        BigDecimal debit = (BigDecimal)value;
        boolean bl = update = debit.signum() > 0 && (!entry.isDebit() || entry.getAmount().compareTo(debit) != 0);
        if (update) {
            entry.setAmount(debit);
            entry.setDebit(true);
            this.tableModel.updateEntry(entry);
            this.tableModel.fireTransaction(entry.getFinancialTransaction());
        }
        return update;
    }
}

