/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.util.Date;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.DateTableCellRenderer;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class DateColumn
extends FinancialTransactionColumn {
    public DateColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        this.renderer = new DateTableCellRenderer();
        this.editor = new DateTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return Date.class;
    }

    @Override
    public String getColumnName() {
        return I18n._((String)"lima.ui.financialtransaction.date", (Object[])new Object[0]);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = this.tableModel.getEntryAt(row);
        FinancialTransaction transaction = entry.getFinancialTransaction();
        Date result = row == 0 || this.tableModel.getEntryAt(row - 1).getFinancialTransaction() != transaction ? transaction.getTransactionDate() : null;
        return result;
    }

    @Override
    public boolean isCellEditable(int row) {
        return row == 0 || this.tableModel.getEntryAt(row).getFinancialTransaction() != this.tableModel.getEntryAt(row - 1).getFinancialTransaction();
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        boolean update;
        FinancialTransaction transaction = this.tableModel.getTransactionAt(row);
        boolean bl = update = transaction.getTransactionDate().compareTo((Date)value) != 0;
        if (update) {
            transaction.setTransactionDate((Date)value);
            this.tableModel.updateTransaction(transaction);
        }
        return update;
    }
}

