/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.AccountTableCellRenderer;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class AccountColumn
extends FinancialTransactionColumn {
    public AccountColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        this.renderer = new AccountTableCellRenderer();
        this.editor = new AccountTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return Account.class;
    }

    @Override
    public String getColumnName() {
        return I18n._((String)"lima.ui.financialtransaction.account", (Object[])new Object[0]);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = this.tableModel.getEntryAt(row);
        return entry.getAccount();
    }

    @Override
    public boolean isCellEditable(int row) {
        return true;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        boolean update;
        Entry entry = this.tableModel.getEntryAt(row);
        Account account = (Account)value;
        boolean bl = update = entry.getAccount() == null != (account == null) || entry.getAccount() != null && account != null && !entry.getAccount().getAccountNumber().equals(account.getAccountNumber());
        if (update) {
            entry.setAccount(account);
            this.tableModel.updateEntry(entry);
        }
        return update;
    }
}

