/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybook;

import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryBookImpl;
import org.chorem.lima.enums.EntryBooksChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.entrybook.EntryBookForm;
import org.chorem.lima.ui.entrybook.EntryBookImportForm;
import org.chorem.lima.ui.entrybook.EntryBookTable;
import org.chorem.lima.ui.entrybook.EntryBookTableModel;
import org.chorem.lima.ui.entrybook.EntryBookView;
import org.chorem.lima.ui.importexport.ImportExport;
import org.nuiton.i18n.I18n;

public class EntryBookViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(EntryBookViewHandler.class);
    protected EntryBookView view;
    protected EntryBookService entryBookService;

    public EntryBookViewHandler(EntryBookView view) {
        this.view = view;
        this.entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
    }

    public void init() {
        this.loadAllEntryBooks();
    }

    protected void loadAllEntryBooks() {
        List entryBooks = this.entryBookService.getAllEntryBooks();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded %d entry books from service", entryBooks.size()));
        }
        EntryBookTableModel model = new EntryBookTableModel(entryBooks);
        EntryBookTable table = this.view.getEntryBooksTable();
        table.setModel(model);
    }

    public void addEntryBook() {
        EntryBookImpl newEntryBook = new EntryBookImpl();
        EntryBookForm entryBookForm = new EntryBookForm((JAXXContext)this.view);
        entryBookForm.setEntryBook((EntryBook)newEntryBook);
        entryBookForm.setLocationRelativeTo((Component)((Object)this.view));
        entryBookForm.setVisible(true);
        newEntryBook = entryBookForm.getEntryBook();
        if (newEntryBook != null) {
            newEntryBook = this.entryBookService.createEntryBook((EntryBook)newEntryBook);
            EntryBookTable entryBookTable = this.view.getEntryBooksTable();
            EntryBookTableModel entryBookTableModel = (EntryBookTableModel)entryBookTable.getModel();
            entryBookTableModel.addEntryBook((EntryBook)newEntryBook);
        }
    }

    public void updateEntryBook() {
        EntryBookTable entryBookTable = this.view.getEntryBooksTable();
        EntryBookTableModel entryBookTableModel = (EntryBookTableModel)entryBookTable.getModel();
        int selectedRow = entryBookTable.getSelectedRow();
        EntryBook selectedEntryBook = entryBookTableModel.getEntryBookAtRow(selectedRow);
        EntryBookForm entryBookForm = new EntryBookForm((JAXXContext)this.view);
        entryBookForm.setAddState(false);
        entryBookForm.setEntryBook(selectedEntryBook);
        entryBookForm.setLocationRelativeTo((Component)((Object)this.view));
        entryBookForm.setVisible(true);
        selectedEntryBook = entryBookForm.getEntryBook();
        if (selectedEntryBook != null) {
            selectedEntryBook = this.entryBookService.updateEntryBook(selectedEntryBook);
            entryBookTableModel.updateEntryBook(selectedEntryBook);
        }
    }

    public void deleteEntryBook() {
        EntryBookTable entryBookTable = this.view.getEntryBooksTable();
        int selectedRow = entryBookTable.getSelectedRow();
        EntryBookTableModel entryBookTableModel = (EntryBookTableModel)entryBookTable.getModel();
        EntryBook selectedEntryBook = entryBookTableModel.getEntryBookAtRow(selectedRow);
        int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.ui.entrybook.deletemessage", (Object[])new Object[]{selectedEntryBook.getLabel()}), I18n._((String)"lima.ui.entrybook.deletetitle", (Object[])new Object[0]), 0, 3);
        if (response == 0) {
            this.entryBookService.removeEntryBook(selectedEntryBook);
            entryBookTableModel.removeEntryBook(selectedEntryBook);
        }
    }

    public void importEntryBooks() {
        EntryBookImportForm form = new EntryBookImportForm((JAXXContext)this.view);
        form.setLocationRelativeTo((Component)((Object)this.view));
        form.setVisible(true);
        Object value = form.getButtonGroup().getSelectedValue();
        if (value != null) {
            EntryBooksChartEnum defaultEntryBooksEnum = (EntryBooksChartEnum)((Object)value);
            ImportExport importExport = new ImportExport((Component)((Object)this.view));
            importExport.importExport(ImportExportEnum.CSV_ENTRYBOOKS_IMPORT, defaultEntryBooksEnum.getFilePath(), true);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("importEntryBooks") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.loadAllEntryBooks();
        }
    }
}

