/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;

public class FiscalPeriodComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FiscalPeriodComboBoxModel.class);
    protected Object selectedFiscalPeriod;
    protected FiscalPeriodService fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
    protected List<FiscalPeriod> datasCache;

    public FiscalPeriodComboBoxModel() {
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.datasCache = this.getDataList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Size of datasCache : " + this.datasCache.size()));
            log.debug((Object)("Beginning and end dates of first fiscal period in datasCache: " + ((FiscalPeriod)this.getElementAt(0)).getBeginDate() + ", " + ((FiscalPeriod)this.getElementAt(0)).getEndDate()));
        }
    }

    public FiscalPeriodComboBoxModel(boolean all) {
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.datasCache = this.getAllDataList();
    }

    @Override
    public int getSize() {
        return this.datasCache.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.datasCache.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Beginning and end dates of first fiscal period : " + ((FiscalPeriod)this.getElementAt(0)).getBeginDate() + ", " + ((FiscalPeriod)this.getElementAt(0)).getEndDate()));
        }
        this.selectedFiscalPeriod = (FiscalPeriod)anItem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedFiscalPeriod;
    }

    public List<FiscalPeriod> getDataList() {
        List result;
        block3: {
            result = null;
            try {
                result = this.fiscalPeriodService.getAllUnblockedFiscalPeriods();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Can't get list accounts", (Throwable)eee);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Size of result : " + result.size()));
            log.debug((Object)("Beginning and end dates of first fiscal period : " + ((FiscalPeriod)result.get(0)).getBeginDate() + ", " + ((FiscalPeriod)result.get(0)).getEndDate()));
        }
        return result;
    }

    public List<FiscalPeriod> getAllDataList() {
        List result;
        block3: {
            result = null;
            try {
                result = this.fiscalPeriodService.getAllFiscalPeriods();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Can't get list accounts", (Throwable)eee);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Size of result : " + result));
            log.debug((Object)("Beginning and end dates of first fiscal period : " + ((FiscalPeriod)result.get(0)).getBeginDate() + ", " + ((FiscalPeriod)result.get(0)).getEndDate()));
        }
        return result;
    }

    public void refresh() {
        this.datasCache = this.getDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void refreshAll() {
        this.datasCache = this.getAllDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FiscalPeriod") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

