/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.chorem.lima.ui.common.TableModelWithGroup;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTable;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import sun.swing.DefaultLookup;

public class EntryTableCellRenderer
implements TableCellRenderer,
Serializable {
    private String text = null;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Border border;
        FinancialTransactionTableModel model;
        JLabel myCell = new JLabel();
        myCell.setOpaque(true);
        myCell.setBorder(new EmptyBorder(1, 1, 1, 1));
        myCell.setName("Table.entryCellRenderer");
        Color background = Color.WHITE;
        Color foreground = Color.BLACK;
        if (isSelected) {
            foreground = table.getSelectionForeground();
            background = table.getSelectionBackground();
        } else {
            Color alternateColor = DefaultLookup.getColor(myCell, myCell.getUI(), "Table.alternateRowColor");
            if (alternateColor != null) {
                if (table.getModel() instanceof TableModelWithGroup) {
                    TableModelWithGroup model2 = (TableModelWithGroup)((Object)table.getModel());
                    if (model2.indexGroupAt(row) % 2 != 0) {
                        background = alternateColor;
                    }
                } else if (row % 2 == 0) {
                    background = alternateColor;
                }
            }
        }
        if (table.isCellEditable(row, column) && (value == null || value instanceof String && ((String)value).isEmpty())) {
            background = new Color(255, 198, 209);
        }
        if (table instanceof FinancialTransactionTable && (model = (FinancialTransactionTableModel)((FinancialTransactionTable)table).getModel()).getBalanceTransactionInRow(row).signum() != 0) {
            foreground = new Color(240, 30, 30);
        }
        if (hasFocus) {
            border = null;
            if (isSelected) {
                border = DefaultLookup.getBorder(myCell, myCell.getUI(), "Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = DefaultLookup.getBorder(myCell, myCell.getUI(), "Table.focusCellHighlightBorder");
            }
            myCell.setBorder(border);
            if (table.getModel().isCellEditable(row, column)) {
                background = Color.WHITE;
                foreground = Color.BLACK;
            }
        } else {
            border = DefaultLookup.getBorder(myCell, myCell.getUI(), "Table.cellNoFocusBorder");
            if (border == null) {
                border = new EmptyBorder(1, 1, 1, 1);
            }
            myCell.setBorder(border);
        }
        myCell.setBackground(background);
        myCell.setForeground(foreground);
        this.setValue(value);
        myCell.setText(this.text);
        return myCell;
    }

    protected void setValue(Object value) {
        this.text = value == null ? "" : value.toString();
    }
}

