/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.chorem.lima.ui.celleditor.EntryTableCellRenderer;

public class BigDecimalTableCellRenderer
extends EntryTableCellRenderer {
    private static final long serialVersionUID = -2499433026151065390L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel myCell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        myCell.setHorizontalAlignment(4);
        return myCell;
    }

    @Override
    public void setValue(Object aValue) {
        Object result = aValue;
        if (aValue != null && aValue instanceof BigDecimal) {
            LimaConfig config = LimaContext.getContext().getConfig();
            String scale = "";
            for (int i = 0; i < config.getScale(); ++i) {
                scale = scale + "0";
            }
            DecimalFormat formatter = new DecimalFormat("##0." + scale);
            DecimalFormatSymbols symbol = new DecimalFormatSymbols();
            symbol.setDecimalSeparator(config.getDecimalSeparator());
            symbol.setGroupingSeparator(config.getThousandSeparator());
            formatter.setDecimalFormatSymbols(symbol);
            formatter.setGroupingUsed(true);
            formatter.setGroupingSize(3);
            result = formatter.format(result);
        }
        super.setValue(result);
    }
}

