/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.util.List;
import org.chorem.lima.beans.FinancialTransactionCondition;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransaction.AccountColumn;
import org.chorem.lima.ui.financialtransaction.BalanceColumn;
import org.chorem.lima.ui.financialtransaction.CreditColumn;
import org.chorem.lima.ui.financialtransaction.DateColumn;
import org.chorem.lima.ui.financialtransaction.DebitColumn;
import org.chorem.lima.ui.financialtransaction.DescriptionColumn;
import org.chorem.lima.ui.financialtransaction.EntryBookColumn;
import org.chorem.lima.ui.financialtransaction.LetterColumn;
import org.chorem.lima.ui.financialtransaction.VoucherColumn;

public class FinancialTransactionSearchTableModel
extends FinancialTransactionTableModel {
    private static final long serialVersionUID = 1L;
    protected final FinancialPeriodService financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
    protected FiscalPeriod selectedFiscalPeriod;
    protected FinancialTransactionCondition financialTransactionCondition;

    protected void refresh(FinancialTransactionCondition financialTransactionCondition) {
        this.financialTransactionCondition = financialTransactionCondition;
        List transactions = this.financialTransactionService.searchFinancialTransaction(this.financialTransactionCondition);
        this.setTransactions(transactions);
    }

    @Override
    protected void initColumn() {
        this.addColumn(new DateColumn());
        this.addColumn(new EntryBookColumn());
        this.addColumn(new VoucherColumn());
        this.addColumn(new AccountColumn());
        this.addColumn(new DescriptionColumn());
        this.addColumn(new LetterColumn());
        this.addColumn(new DebitColumn());
        this.addColumn(new CreditColumn());
        this.addColumn(new BalanceColumn());
    }

    public void setFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.selectedFiscalPeriod = fiscalPeriod;
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if ((serviceName.contains("FinancialTransaction") || methodeName.contains("importEntries") || methodeName.contains("importAll")) && !methodeName.contains("search")) {
            this.refresh(this.financialTransactionCondition);
        }
    }
}

