/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.Filter.StringCondition;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.AbstractStringCondition;
import org.chorem.lima.beans.Condition;
import org.chorem.lima.beans.VoucherCondition;
import org.chorem.lima.ui.Filter.ConditionHandler;
import org.chorem.lima.ui.Filter.StringCondition.StringConditionView;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionHandler;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;

public class StringConditionHandler
implements ConditionHandler {
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchViewHandler.class);
    protected StringConditionView view;
    protected AbstractStringCondition condition;
    protected FinancialTransactionConditionHandler filterHandler;

    public StringConditionHandler(StringConditionView view) {
        this.view = view;
        this.condition = new VoucherCondition();
    }

    public String getText() {
        return this.condition.getValue();
    }

    public void setText(String text) {
        this.condition.setValue(text);
    }

    public void setText(KeyEvent event) {
        String text = this.view.getTextField().getText();
        this.setText(text);
    }

    public void setOperand(AbstractStringCondition.Operand operand) {
        this.condition.setOperand(operand);
    }

    public AbstractStringCondition.Operand getOperand() {
        return this.condition.getOperand();
    }

    public boolean isSensitiveCase() {
        return this.condition.isSensitiveCase();
    }

    public void setSensitiveCase(boolean sensitiveCase) {
        this.condition.setSensitiveCase(sensitiveCase);
    }

    public void setSensitiveCase(ActionEvent event) {
        boolean selected = this.view.getSensitiveCaseCheckBox().isSelected();
        this.setSensitiveCase(selected);
    }

    public void delete() {
        this.filterHandler.removeCondition(this);
    }

    public void operandSelected(ItemEvent event) {
        this.condition.setOperand((AbstractStringCondition.Operand)event.getItem());
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    public StringConditionView getView() {
        return this.view;
    }

    @Override
    public void setFilterHandler(FinancialTransactionConditionHandler filterHandler) {
        this.filterHandler = filterHandler;
    }
}

