package org.chorem.lima.ui.identity;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Identity;
import static org.nuiton.i18n.I18n.t;

public class IdentityForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_IDENTITY = "identity";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADDRESS2_TEXT_FIELD_TEXT = "address2TextField.text";
    public static final String BINDING_ADDRESS_TEXT_FIELD_TEXT = "addressTextField.text";
    public static final String BINDING_BUSINESS_NUMBER_TEXT_FIELD_TEXT = "businessNumberTextField.text";
    public static final String BINDING_CITY_TEXT_FIELD_TEXT = "cityTextField.text";
    public static final String BINDING_CLASSIFICATION_CODE_TEXT_FIELD_TEXT = "classificationCodeTextField.text";
    public static final String BINDING_DESCRIPTION_TEXT_FIELD_TEXT = "descriptionTextField.text";
    public static final String BINDING_EMAIL_TEXT_FIELD_TEXT = "emailTextField.text";
    public static final String BINDING_NAME_TEXT_FIELD_TEXT = "nameTextField.text";
    public static final String BINDING_PHONE_NUMBER_TEXT_FIELD_TEXT = "phoneNumberTextField.text";
    public static final String BINDING_VAT_NUMBER_TEXT_FIELD_TEXT = "vatNumberTextField.text";
    public static final String BINDING_ZIP_CODE_TEXT_FIELD_TEXT = "zipCodeTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVTW8UNxjHnYVN2KShIYGEBBChDQIJdTYvhBAlvJRNV0m6JWoDArEVwrvjZA2esRl7YOgB8RH4CHDngsStp6qHnjlwQXyFquqBK+rj2bdM4imDnMNk1n6e3/P3M7b/r/5GeRmgU/dxFDlB6CvqEWf9+9u3N2r3SV2tEFkPqFA8QM2/nhzKVdGA2xmXCn1brej0Yiu9WOKe4D7xd2QvVVC/VE8YkQ1ClEInkhl1KYubnemlSIRBm9oRZaK++Pef3HP32cscQpEAdWdgKZOfy+quZH8F5air0DBUeoSLDPvbICOg/jboHdRjJYalvI498hA9RX0V1CtwADCFvsm+5JgR50dCocLU+grFjG9PK3SWB9tOvcED4jmMetgJqUNdoFD1xFlrvZR54AkRA3oV6mtg32UkUOhcluTVZnQ3/0A7RKGTuwG7cncUnbqBa4yA4qOJ5srH0ConntORhW6VqfUKrhEGGcO6jVErtDmqg4Y7sYM+tPcGiVSZEgYfYzSR0JlIJvVPrfB66IFQKDG+M0NBgtOeFHsUzejfY0nY4fZuptxP1JtIKxpTTuylzxroQ9h1AyJlNvJsCnnOQD7UIs9mQ8+loM+bRP9GRYm7JBv5fAp53kAerMPWyoadT8FeMGDHaqGkPjTjeujVSJCtwIWUAguGAsOPsPoS9kIK+6KBfayurwi6RetY78Hsjb+YUmTRtMtFA26oL1nC4i56oX2Gpg34g8TDlP0feKB7fKb3kq+FSnEfTvNI4vw3h5OgHH+g335tjQboWOJWAjNxumbSve17qigfhDAM11h1r//8AlNN5zm6y3k0MJ79NDry7vcPb8ptu5mA2keMoTvcEmxABFzAlU116a+bXhMqyoo/YbFURQVJGFhtbKXHDcI2W9MgDuod0umOTndWsWwAIt/3/o8/R++93YdyZdTPOHbLWMevoYJqwP3Q4MyNxJWrsaKvHh+A55DWptARl2zhkKkS45JsgMR4+8G3XHaxwpM16rvwES5H0JPjhp50hNUKf30c2Xx9td2XHtA5nhre7U3+DuqlPoNzGxtxy2ONxjsgJAld3vVSk7v26P/9orWv3PjZMC0873EXMzjUy83yk1iB7ddCRWCxOovFq9Bvfmbofm09elaaGaOfZejhSD8emAnj2QkpGk5aazhlreG0tYYz1hrOWWv4zlrDjLWGOWsNC9YaFq01XLLWcMVaQ8laww/WGtasNfxorWHDWsPP1hpuWmu4Za2hak24C4T/AG+XKYRdDwAA";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT10 = "$Document10";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    public static final String PROPERTY$DOCUMENT3 = "$Document3";
    public static final String PROPERTY$DOCUMENT4 = "$Document4";
    public static final String PROPERTY$DOCUMENT5 = "$Document5";
    public static final String PROPERTY$DOCUMENT6 = "$Document6";
    public static final String PROPERTY$DOCUMENT7 = "$Document7";
    public static final String PROPERTY$DOCUMENT8 = "$Document8";
    public static final String PROPERTY$DOCUMENT9 = "$Document9";
    private static final Log log = LogFactory.getLog(IdentityForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField address2TextField;
    protected JTextField addressTextField;
    protected JTextField businessNumberTextField;
    protected JTextField cityTextField;
    protected JTextField classificationCodeTextField;
    protected JTextField descriptionTextField;
    protected JTextField emailTextField;
    protected IdentityHandler handler;
    protected Identity identity;
    protected JTextField nameTextField;
    protected JButton ok;
    protected JTextField phoneNumberTextField;
    protected JTextField vatNumberTextField;
    protected JTextField zipCodeTextField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private Document $Document1;
    private Document $Document10;
    private Document $Document2;
    private Document $Document3;
    private Document $Document4;
    private Document $Document5;
    private Document $Document6;
    private Document $Document7;
    private Document $Document8;
    private Document $Document9;
    private JButton $JButton0;
    private IdentityForm $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel10;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JLabel $JLabel9;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            setIdentity(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public IdentityForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm() {
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IdentityForm(Window param0) {
        super(param0);
        $initialize();
    }

    public IdentityForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateIdentity(getIdentity());                 dispose();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setName(getNameTextField().getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setDescription(getDescriptionTextField().getText());
    }

    public void doInsertUpdate__on__$Document10(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setEmail(getEmailTextField().getText());
    }

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setAddress(getAddressTextField().getText());
    }

    public void doInsertUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setAddress2(getAddress2TextField().getText());
    }

    public void doInsertUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setZipCode(getZipCodeTextField().getText());
    }

    public void doInsertUpdate__on__$Document5(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setCity(getCityTextField().getText());
    }

    public void doInsertUpdate__on__$Document6(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setBusinessNumber(getBusinessNumberTextField().getText());
    }

    public void doInsertUpdate__on__$Document7(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setVatNumber(getVatNumberTextField().getText());
    }

    public void doInsertUpdate__on__$Document8(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setClassificationCode(getClassificationCodeTextField().getText());
    }

    public void doInsertUpdate__on__$Document9(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setPhoneNumber(getPhoneNumberTextField().getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setName(getNameTextField().getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setDescription(getDescriptionTextField().getText());
    }

    public void doRemoveUpdate__on__$Document10(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setEmail(getEmailTextField().getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setAddress(getAddressTextField().getText());
    }

    public void doRemoveUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setAddress2(getAddress2TextField().getText());
    }

    public void doRemoveUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setZipCode(getZipCodeTextField().getText());
    }

    public void doRemoveUpdate__on__$Document5(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setCity(getCityTextField().getText());
    }

    public void doRemoveUpdate__on__$Document6(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setBusinessNumber(getBusinessNumberTextField().getText());
    }

    public void doRemoveUpdate__on__$Document7(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setVatNumber(getVatNumberTextField().getText());
    }

    public void doRemoveUpdate__on__$Document8(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setClassificationCode(getClassificationCodeTextField().getText());
    }

    public void doRemoveUpdate__on__$Document9(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getIdentity().setPhoneNumber(getPhoneNumberTextField().getText());
    }

    public void doWindowClosing__on__$JDialog0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getAddress2TextField() {
        return address2TextField;
    }

    public JTextField getAddressTextField() {
        return addressTextField;
    }

    public JTextField getBusinessNumberTextField() {
        return businessNumberTextField;
    }

    public JTextField getCityTextField() {
        return cityTextField;
    }

    public JTextField getClassificationCodeTextField() {
        return classificationCodeTextField;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public JTextField getEmailTextField() {
        return emailTextField;
    }

    public IdentityHandler getHandler() {
        return handler;
    }

    public Identity getIdentity() {
        return identity;
    }

    public JTextField getNameTextField() {
        return nameTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public JTextField getPhoneNumberTextField() {
        return phoneNumberTextField;
    }

    public JTextField getVatNumberTextField() {
        return vatNumberTextField;
    }

    public JTextField getZipCodeTextField() {
        return zipCodeTextField;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document10(Document $Document10) {
        Document oldValue = this.$Document10;
        this.$Document10 = $Document10;
        firePropertyChange(PROPERTY$DOCUMENT10, oldValue, $Document10);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void set$Document3(Document $Document3) {
        Document oldValue = this.$Document3;
        this.$Document3 = $Document3;
        firePropertyChange(PROPERTY$DOCUMENT3, oldValue, $Document3);
    }

    public void set$Document4(Document $Document4) {
        Document oldValue = this.$Document4;
        this.$Document4 = $Document4;
        firePropertyChange(PROPERTY$DOCUMENT4, oldValue, $Document4);
    }

    public void set$Document5(Document $Document5) {
        Document oldValue = this.$Document5;
        this.$Document5 = $Document5;
        firePropertyChange(PROPERTY$DOCUMENT5, oldValue, $Document5);
    }

    public void set$Document6(Document $Document6) {
        Document oldValue = this.$Document6;
        this.$Document6 = $Document6;
        firePropertyChange(PROPERTY$DOCUMENT6, oldValue, $Document6);
    }

    public void set$Document7(Document $Document7) {
        Document oldValue = this.$Document7;
        this.$Document7 = $Document7;
        firePropertyChange(PROPERTY$DOCUMENT7, oldValue, $Document7);
    }

    public void set$Document8(Document $Document8) {
        Document oldValue = this.$Document8;
        this.$Document8 = $Document8;
        firePropertyChange(PROPERTY$DOCUMENT8, oldValue, $Document8);
    }

    public void set$Document9(Document $Document9) {
        Document oldValue = this.$Document9;
        this.$Document9 = $Document9;
        firePropertyChange(PROPERTY$DOCUMENT9, oldValue, $Document9);
    }

    public void setHandler(IdentityHandler handler) {
        IdentityHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setIdentity(Identity identity) {
        Identity oldValue = this.identity;
        this.identity = identity;
        firePropertyChange(PROPERTY_IDENTITY, oldValue, identity);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected Document get$Document10() {
        return $Document10;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected Document get$Document3() {
        return $Document3;
    }

    protected Document get$Document4() {
        return $Document4;
    }

    protected Document get$Document5() {
        return $Document5;
    }

    protected Document get$Document6() {
        return $Document6;
    }

    protected Document get$Document7() {
        return $Document7;
    }

    protected Document get$Document8() {
        return $Document8;
    }

    protected Document get$Document9() {
        return $Document9;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddress2TextField() {
        $objectMap.put("address2TextField", address2TextField = new JTextField());
        
        address2TextField.setName("address2TextField");
        address2TextField.setColumns(15);
    }

    protected void createAddressTextField() {
        $objectMap.put("addressTextField", addressTextField = new JTextField());
        
        addressTextField.setName("addressTextField");
        addressTextField.setColumns(15);
    }

    protected void createBusinessNumberTextField() {
        $objectMap.put("businessNumberTextField", businessNumberTextField = new JTextField());
        
        businessNumberTextField.setName("businessNumberTextField");
        businessNumberTextField.setColumns(15);
    }

    protected void createCityTextField() {
        $objectMap.put("cityTextField", cityTextField = new JTextField());
        
        cityTextField.setName("cityTextField");
        cityTextField.setColumns(15);
    }

    protected void createClassificationCodeTextField() {
        $objectMap.put("classificationCodeTextField", classificationCodeTextField = new JTextField());
        
        classificationCodeTextField.setName("classificationCodeTextField");
        classificationCodeTextField.setColumns(15);
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createEmailTextField() {
        $objectMap.put("emailTextField", emailTextField = new JTextField());
        
        emailTextField.setName("emailTextField");
        emailTextField.setColumns(15);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new IdentityHandler());
    }

    protected void createIdentity() {
        $objectMap.put("identity", identity = handler.getIdentity());
    }

    protected void createNameTextField() {
        $objectMap.put("nameTextField", nameTextField = new JTextField());
        
        nameTextField.setName("nameTextField");
        nameTextField.setColumns(15);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.common.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createPhoneNumberTextField() {
        $objectMap.put("phoneNumberTextField", phoneNumberTextField = new JTextField());
        
        phoneNumberTextField.setName("phoneNumberTextField");
        phoneNumberTextField.setColumns(15);
    }

    protected void createVatNumberTextField() {
        $objectMap.put("vatNumberTextField", vatNumberTextField = new JTextField());
        
        vatNumberTextField.setName("vatNumberTextField");
        vatNumberTextField.setColumns(15);
    }

    protected void createZipCodeTextField() {
        $objectMap.put("zipCodeTextField", zipCodeTextField = new JTextField());
        
        zipCodeTextField.setName("zipCodeTextField");
        zipCodeTextField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addressTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(address2TextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(zipCodeTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cityTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel6, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(businessNumberTextField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel7, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vatNumberTextField, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel8, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(classificationCodeTextField, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel9, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(phoneNumberTextField, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel10, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(emailTextField, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createHandler();
        createIdentity();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("lima.identity.name"));
        createNameTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getNameTextField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("lima.identity.description"));
        createDescriptionTextField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = getDescriptionTextField().getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("lima.identity.address"));
        createAddressTextField();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = getAddressTextField().getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("lima.identity.address2"));
        createAddress2TextField();
        // inline creation of $Document3
        $objectMap.put("$Document3", $Document3 = getAddress2TextField().getDocument());
        
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document3"));
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document3"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("lima.identity.zipCode"));
        createZipCodeTextField();
        // inline creation of $Document4
        $objectMap.put("$Document4", $Document4 = getZipCodeTextField().getDocument());
        
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document4"));
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document4"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("lima.identity.city"));
        createCityTextField();
        // inline creation of $Document5
        $objectMap.put("$Document5", $Document5 = getCityTextField().getDocument());
        
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document5"));
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document5"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(t("lima.identity.businessNumber"));
        createBusinessNumberTextField();
        // inline creation of $Document6
        $objectMap.put("$Document6", $Document6 = getBusinessNumberTextField().getDocument());
        
        $Document6.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document6"));
        $Document6.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document6"));
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(t("lima.identity.vatNumber"));
        createVatNumberTextField();
        // inline creation of $Document7
        $objectMap.put("$Document7", $Document7 = getVatNumberTextField().getDocument());
        
        $Document7.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document7"));
        $Document7.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document7"));
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(t("lima.identity.classificationCode"));
        createClassificationCodeTextField();
        // inline creation of $Document8
        $objectMap.put("$Document8", $Document8 = getClassificationCodeTextField().getDocument());
        
        $Document8.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document8"));
        $Document8.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document8"));
        // inline creation of $JLabel9
        $objectMap.put("$JLabel9", $JLabel9 = new JLabel());
        
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(t("lima.identity.phoneNumber"));
        createPhoneNumberTextField();
        // inline creation of $Document9
        $objectMap.put("$Document9", $Document9 = getPhoneNumberTextField().getDocument());
        
        $Document9.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document9"));
        $Document9.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document9"));
        // inline creation of $JLabel10
        $objectMap.put("$JLabel10", $JLabel10 = new JLabel());
        
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(t("lima.identity.email"));
        createEmailTextField();
        // inline creation of $Document10
        $objectMap.put("$Document10", $Document10 = getEmailTextField().getDocument());
        
        $Document10.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document10"));
        $Document10.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document10"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("lima.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        $JDialog0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JDialog0"));
        
        getRootPane().setDefaultButton(ok);// registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(nameTextField, getIdentity().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(descriptionTextField, getIdentity().getDescription());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADDRESS_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("address", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(addressTextField, getIdentity().getAddress());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("address", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADDRESS2_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("address2", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(address2TextField, getIdentity().getAddress2());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("address2", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ZIP_CODE_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("zipCode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(zipCodeTextField, getIdentity().getZipCode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("zipCode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CITY_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("city", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(cityTextField, getIdentity().getCity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("city", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSINESS_NUMBER_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("businessNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(businessNumberTextField, getIdentity().getBusinessNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("businessNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VAT_NUMBER_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("vatNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(vatNumberTextField, getIdentity().getVatNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("vatNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLASSIFICATION_CODE_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("classificationCode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(classificationCodeTextField, getIdentity().getClassificationCode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("classificationCode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PHONE_NUMBER_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("phoneNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(phoneNumberTextField, getIdentity().getPhoneNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("phoneNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().addPropertyChangeListener("email", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getIdentity() != null) {
                    SwingUtil.setText(emailTextField, getIdentity().getEmail());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("identity", this);
                if (getIdentity() != null) {
                    getIdentity().removePropertyChangeListener("email", this);
                }
            }
        });
    }

}