package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * $Id: CreditColumn.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.3/lima-swing/src/main/java/org/chorem/lima/ui/financialtransaction/CreditColumn.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.common.AbstractColumn;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;

import java.math.BigDecimal;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class CreditColumn extends AbstractColumn<FinancialTransactionTableModel> {

    public CreditColumn() {
        super(BigDecimal.class, t("lima.ui.financialtransaction.credit"), true);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = tableModel.get(row);
        return entry.getDebit() ? BigDecimal.ZERO : entry.getAmount();
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        Entry entry = tableModel.get(row);
        BigDecimal credit= (BigDecimal) value;
        boolean update = (credit.signum() > 0 && (entry.isDebit() || entry.getAmount().compareTo(credit) != 0));
        if (update) {
            entry.setAmount(credit);
            entry.setDebit(false);
            tableModel.updateEntry(entry);
            tableModel.fireTransaction(entry.getFinancialTransaction());
        }
        return update;
    }
}
