/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.ledger;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class LedgerTable
extends JXTable
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 3133690382049594727L;
    private Highlighter colorReportsDatas;

    public LedgerTable() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
        this.addColorReportsDatas();
    }

    protected void addColorReportsDatas() {
        if (this.colorReportsDatas != null) {
            this.removeHighlighter(this.colorReportsDatas);
        }
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                return adapter.getValueAt(adapter.row, 0) != null;
            }
        };
        this.colorReportsDatas = new ColorHighlighter(predicate, new Color(222, 222, 222), null);
        this.addHighlighter(this.colorReportsDatas);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.rowAtPoint(e.getPoint()) == -1) {
            this.clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && !this.isEditing()) {
            this.clearSelection();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

