/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.Filter.fiscalPeriodCondition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.Condition;
import org.chorem.lima.beans.FiscalPeriodCondition;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.Filter.ConditionHandler;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionHandler;
import org.chorem.lima.ui.Filter.fiscalPeriodCondition.FiscalPeriodConditionView;

public class FiscalPeriodConditionHandler
implements ConditionHandler {
    private static final Log log = LogFactory.getLog(FiscalPeriodConditionHandler.class);
    protected FiscalPeriodConditionView view;
    protected FiscalPeriodCondition condition;
    protected FinancialTransactionConditionHandler filterHandler;

    public FiscalPeriodConditionHandler(FiscalPeriodConditionView view) {
        this.view = view;
        this.condition = new FiscalPeriodCondition();
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public JComponent getView() {
        return this.view;
    }

    @Override
    public void setFilterHandler(FinancialTransactionConditionHandler filterHandler) {
        this.filterHandler = filterHandler;
    }

    public Object[] getFiscalPeriodList() {
        Object[] result;
        block2: {
            FiscalPeriodService fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
            result = new Object[]{};
            try {
                List periods = fiscalPeriodService.getAllFiscalPeriods();
                result = periods.toArray();
            }
            catch (LimaException ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get Fiscal Period list", (Throwable)ex);
            }
        }
        return result;
    }

    public void setFiscalPeriod(ListSelectionEvent event) {
        JList fiscalPeriodList = this.view.getFiscalPeriodList();
        ArrayList<Object> selectedValuesList = new ArrayList<Object>(Arrays.asList(fiscalPeriodList.getSelectedValues()));
        this.condition.setFiscalPeriods(selectedValuesList);
    }

    public void delete() {
        this.filterHandler.removeCondition(this);
    }
}

