/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LimaSplash {
    private static Log log = LogFactory.getLog(LimaSplash.class);
    protected SplashScreen splash = SplashScreen.getSplashScreen();
    protected Graphics2D splashGraphics;

    public LimaSplash() {
        if (this.splash != null) {
            this.splashGraphics = this.splash.createGraphics();
        }
    }

    public void initSplash() {
        if (this.splashGraphics != null) {
            this.splashGraphics.setColor(Color.GRAY);
            this.splashGraphics.drawRect(65, 253, 300, 10);
            this.splashGraphics.fillRect(65, 253, 0, 10);
            this.splashGraphics.setColor(Color.DARK_GRAY);
            Font font = new Font("Lucida Sans", 1, 14);
            this.splashGraphics.setFont(font);
            this.splashGraphics.drawString("Lutin Invoice Monitoring and Accounting", 65, 249);
            this.splash.update();
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Can't find splash screen");
            log.warn((Object)"Make sure that lima is launched with -splash:image.png VM argument");
            log.warn((Object)"or SplashScreen-Image is present in jar manifest.");
        }
    }

    public void drawVersion(String version) {
        if (this.splashGraphics != null) {
            this.splashGraphics.setColor(Color.DARK_GRAY);
            Font font = new Font("Lucida Sans", 0, 12);
            this.splashGraphics.setFont(font);
            this.splashGraphics.setColor(Color.BLACK);
            this.splashGraphics.drawString("Version : " + version, 394, 42);
            this.splash.update();
        }
    }

    public void updateProgression(double progress, String message) {
        if (this.splashGraphics != null && this.splash.isVisible()) {
            this.splashGraphics.setColor(Color.GRAY);
            this.splashGraphics.drawRect(65, 253, 300, 10);
            this.splashGraphics.fillRect(65, 253, (int)(300.0 * progress), 10);
            if (message != null) {
                this.splashGraphics.setComposite(AlphaComposite.Clear);
                this.splashGraphics.fillRect(65, 238, 300, 15);
                this.splashGraphics.setPaintMode();
                this.splashGraphics.setColor(Color.DARK_GRAY);
                Font font = new Font("Lucida Sans", 1, 14);
                this.splashGraphics.setFont(font);
                this.splashGraphics.drawString(message + "...", 65, 249);
            }
            this.splash.update();
        }
    }

    public void closeSplash() {
        if (this.splash != null && this.splash.isVisible()) {
            this.splash.close();
        }
    }
}

