/*
 * #%L
 * Lima :: Swing
 * 
 * $Id: VatReportViewHandler.java 3633 2012-08-23 16:57:32Z mallon $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/vatreports/VatReportViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.vatreports;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.api.DocumentService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;

public class VatReportViewHandler {
    /** log. */
    private static final Log log =
            LogFactory.getLog(VatReportViewHandler.class);

    protected VatReportView view;
    protected DocumentService documentService;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;
    private static SimpleDateFormat dateFormat =
            new SimpleDateFormat("yyyy-MM-dd");
    protected int port;

    protected VatReportViewHandler(VatReportView view) {
        this.view = view;

        port = LimaServiceFactory.getService(HttpServerService.class).getHttpPort();

        documentService = LimaServiceFactory.getService(DocumentService.class);
        fiscalPeriodService = LimaServiceFactory.getService(FiscalPeriodService.class);
        financialPeriodService = LimaServiceFactory.getService(FinancialPeriodService.class);
    }

    /**
     * Init data models and displayed objects.
     */
    public void init() {
        List<FiscalPeriod> blockedFiscalPeriods = fiscalPeriodService.getAllFiscalPeriods();
        List<FinancialPeriod> financialPeriod = financialPeriodService.getUnblockedFinancialPeriods();
        view.getIntervalPanel().init(blockedFiscalPeriods, financialPeriod);
    }

    /** Edit VAT document */
    public void editVat() {
        if (view.getIntervalPanel().getBeginDate() != null || view.getIntervalPanel().getEndDate() != null) {
            String address = LimaConfig.getInstance().getHostAdress();

            if (log.isDebugEnabled()) {
                log.debug("autocomplete : " + view.getAutoComplete());
            }

            try {
                String url = "http://" + address + ":" + port + "/?beginDate="
                             + dateFormat.format(view.getIntervalPanel().getBeginDate())
                             + "&endDate=" + dateFormat.format(view.getIntervalPanel().getEndDate())
                             + "&format=.pdf&model=" + DocumentsEnum.VAT.getFileName()
                             + "&autocomplete=" + view.getAutoComplete();
                Desktop.getDesktop().browse(new URI(url));
            } catch (IOException e) {
                log.error("Can't open browser", e);
            } catch (URISyntaxException e) {
                log.error("Can't create news URI", e);
            }
        }
    }

}
