/*
 * #%L
 * Lima Swing
 * 
 * $Id: LedgerViewHandler.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/ledger/LedgerViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.ledger;

import static org.nuiton.i18n.I18n.t;

import java.awt.Desktop;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.swing.JOptionPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.beans.BalanceTrial;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.api.ReportService;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.business.utils.EntryComparator;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;

/**
 * Handler associated with accounts reports view.
 * By : $Author: sbavencoff $
 */
public class LedgerViewHandler /*implements ServiceListener*/ {

    protected LedgerView view;

    protected LedgerTableModel model;

    /** log. */
    private static final Log log = LogFactory.getLog(LedgerViewHandler.class);

    /** Services. */
    protected ReportService reportService;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;

    private static SimpleDateFormat dateFormat =
            new SimpleDateFormat("yyyy-MM-dd");

    protected LedgerViewHandler(LedgerView view) {
        this.view = view;

        fiscalPeriodService = LimaServiceFactory.getService(FiscalPeriodService.class);
        financialPeriodService = LimaServiceFactory.getService(FinancialPeriodService.class);
    }

    /**
     * Init data models and displayed objects.
     */
    public void init() {

        // init data models
        List<FiscalPeriod> fiscalPeriod = fiscalPeriodService.getAllFiscalPeriods();
        List<FinancialPeriod> financialPeriod = financialPeriodService.getUnblockedFinancialPeriods();
        view.getIntervalPanel().init(fiscalPeriod, financialPeriod);
    }

    public void createDocument() {

        Date beginDate = view.getIntervalPanel().getBeginDate();
        Date endDate = view.getIntervalPanel().getEndDate();
        
        if (beginDate != null && endDate != null) {
            String address = LimaConfig.getInstance().getHostAdress();

            try {
                int port = LimaServiceFactory.getService(HttpServerService.class).getHttpPort();
                String url = "http://" + address + ":" + port + "/?beginDate="
                             + dateFormat.format(beginDate)
                             + "&endDate=" + dateFormat.format(endDate)
                             + "&format=.html&model="
                             + DocumentsEnum.LEDGER.getFileName();
                Desktop.getDesktop().browse(new URI(url));
            } catch (IOException e) {
                log.error("Can't open browser", e);
            } catch (URISyntaxException e) {
                log.error("Can't create news URI", e);
            }
        }
    }

   /* @Override
    public void notifyMethod(String serviceName, String methodName) {
        if (serviceName.contains("FinancialTransaction") ||
            methodName.contains("importAccount") ||
            methodName.contains("importAll")) {
            refreshData();
        }
    }*/

}
