/*
 * #%L
 * Lima Swing
 * 
 * $Id: FiscalPeriodTableModel.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/fiscalperiod/FiscalPeriodTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.fiscalperiod;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.utils.FiscalPeriodComparator;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.common.AbstractColumn;
import org.chorem.lima.ui.common.AbstractLimaTableModel;

import java.util.Date;

import static org.nuiton.i18n.I18n.t;

/**
 * Modele de Fiscal period (rendu de list)
 *
 * @author chatellier
 * @version $Revision: 3777 $
 *          <p/>
 *          Last update : $Date: 2014-04-14 09:29:08 +0200 (Mon, 14 Apr 2014) $
 *          By : $Author: sbavencoff $
 */
public class FiscalPeriodTableModel extends AbstractLimaTableModel<FiscalPeriod> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 77027335135838258L;

    private static final Log log = LogFactory.getLog(FiscalPeriodTableModel.class);

    public FiscalPeriodTableModel() {
        comparator = new FiscalPeriodComparator();
    }

    @Override
    protected void initColumn() {
        addColumn(new AbstractColumn<FiscalPeriodTableModel>(Date.class, t("lima.ui.fiscalperiod.begin"), false) {
            @Override
            public Object getValueAt(int row) {
                FiscalPeriod fiscalPeriod = tableModel.get(row);
                return fiscalPeriod.getBeginDate();
            }
        });

        addColumn(new AbstractColumn<FiscalPeriodTableModel>(Date.class, t("lima.ui.fiscalperiod.end"), false) {
            @Override
            public Object getValueAt(int row) {
                FiscalPeriod fiscalPeriod = tableModel.get(row);
                return fiscalPeriod.getEndDate();
            }
        });

        addColumn(new AbstractColumn<FiscalPeriodTableModel>(String.class, t("lima.ui.fiscalperiod.status"), false) {
            @Override
            public Object getValueAt(int row) {
                FiscalPeriod fiscalPeriod = tableModel.get(row);
                String status = t("lima.ui.fiscalperiod.open");
                if (fiscalPeriod.getLocked()) {
                    status =  t("lima.ui.fiscalperiod.closed");
                }
                return status;
            }

        });
    }
}
