/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBooksReportsViewHandler.java 3626 2012-08-21 14:16:49Z mallon $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/entrybooksreports/EntryBooksReportsViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.entrybooksreports;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.api.DocumentService;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.business.api.ReportService;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;

/**
 * Handler associated with accounts reports view.
 * 
 * By : $Author: mallon $
 */
public class EntryBooksReportsViewHandler{

    /** log. */
    private static final Log log = LogFactory.getLog(EntryBooksReportsViewHandler.class);

    protected EntryBooksReportsView view;

    /** Services. */
    protected ReportService reportService;
    protected DocumentService documentService;
    protected EntryBookService entryBookService;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;

    private static SimpleDateFormat dateFormat =
            new SimpleDateFormat("yyyy-MM-dd");

    public EntryBooksReportsViewHandler(EntryBooksReportsView view) {
        this.view = view;

        reportService = LimaServiceFactory.getService(ReportService.class);
        documentService = LimaServiceFactory.getService(DocumentService.class);
        reportService = LimaServiceFactory.getService(ReportService.class);
        entryBookService = LimaServiceFactory.getService(EntryBookService.class);
        fiscalPeriodService = LimaServiceFactory.getService(FiscalPeriodService.class);
        financialPeriodService = LimaServiceFactory.getService(FinancialPeriodService.class);
    }

    /**
     * Init data models and displayed objects.
     */
    public void init() {
        List<FiscalPeriod> blockedFiscalPeriods = fiscalPeriodService.getAllFiscalPeriods();
        List<FinancialPeriod> financialPeriod = financialPeriodService.getUnblockedFinancialPeriods();
        view.getIntervalPanel().init(blockedFiscalPeriods, financialPeriod);
    }

    public void createDocument() {

        Date beginDate = view.getIntervalPanel().getBeginDate();
        Date endDate = view.getIntervalPanel().getEndDate();
        
        if (beginDate != null && endDate != null) {

            int port = LimaServiceFactory.getService(HttpServerService.class).getHttpPort();
            String address = LimaConfig.getInstance().getHostAdress();

            try {
                String url = "http://" + address + ":" + port + "/?beginDate="
                             + dateFormat.format(beginDate)
                             + "&endDate=" + dateFormat.format(endDate)
                             + "&format=.html&model="
                             + DocumentsEnum.ENTRYBOOKS.getFileName();
                Desktop.getDesktop().browse(new URI(url));

                String url2 = "http://" + address + ":" + port + "/?beginDate="
                              + dateFormat.format(beginDate)
                              + "&endDate=" + dateFormat.format(endDate)
                              + "&format=.html&model="
                              + DocumentsEnum.GENERAL_ENTRYBOOK.getFileName();
                Desktop.getDesktop().browse(new URI(url2));

            } catch (IOException e) {
                log.error("Can't open browser", e);
            } catch (URISyntaxException e) {
                log.error("Can't create news URI", e);
            }
        }
    }
}
