/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBooksReportsTableModel.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/entrybooksreports/EntryBooksReportsTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.entrybooksreports;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;

import javax.swing.table.AbstractTableModel;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

import static org.nuiton.i18n.I18n.t;

/**
 * Entry book table model.
 * By : $Author: sbavencoff $
 */
public class EntryBooksReportsTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** log. */
    private static final Log log = LogFactory.getLog(EntryBooksReportsTableModel.class);

    /** data cache */
    protected ReportsDatas reportData;

    @Override
    public int getRowCount() {
        int result = 0;

        // just prevent too much result
        if (reportData != null && reportData.getListEntry() != null) {
            result = reportData.getListEntry().size();
        }

        return result;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Class<?> getColumnClass(int column) {

        Class<?> result = null;

        switch (column) {
            case 0:
                result = Date.class;
                break;
            case 1:
                result = Account.class;
                break;
            case 2:
                result = String.class;
                break;
            case 3:
                result = String.class;
                break;
            case 4:
                result = String.class;
                break;
            case 5:
                result = BigDecimal.class;
                break;
            case 6:
                result = BigDecimal.class;
                break;
        }

        return result;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0:
                res = t("lima.table.date");
                break;
            case 1:
                res = t("lima.table.account");
                break;
            case 2:
                res = t("lima.table.voucher");
                break;
            case 3:
                res = t("lima.table.description");
                break;
            case 4:
                res = t("lima.table.letter");
                break;
            case 5:
                res = t("lima.table.debit");
                break;
            case 6:
                res = t("lima.table.credit");
                break;
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (reportData.getListEntry() != null) {
            Entry currentRow = reportData.getListEntry().get(row);
            SimpleDateFormat simpleDateFormat =
                    new SimpleDateFormat("dd MMMMM yyyy");

            switch (column) {
                case 0:
                    result = simpleDateFormat.
                            format(currentRow.getFinancialTransaction().getTransactionDate());
                    break;
                case 1:
                    if (currentRow.getAccount() != null) {
                        result = currentRow.getAccount().getAccountNumber();
                    } else {
                        result = null;
                    }
                    break;
                case 2:
                    result = currentRow.getVoucher();
                    break;
                case 3:
                    result = currentRow.getDescription();
                    break;
                case 4:
                    result = currentRow.getLettering();
                    break;
                case 5:
                    result = currentRow.getDebit() ? currentRow.getAmount() : BigDecimal.ZERO;
                    break;
                case 6:
                    result = currentRow.getDebit() ? BigDecimal.ZERO : currentRow.getAmount();
                    break;
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("No EntryBook selected skip table model update");
            }
        }

        return result;
    }

    public Entry getElementAt(int row) {
        return reportData.getListEntry().get(row);
    }

    public void setReportDatas(ReportsDatas datasList) {
        reportData = datasList;
        fireTableDataChanged();
    }

}
