/*
 * #%L
 * $Id: EntryBookListRenderer.java 3585 2012-08-08 14:52:14Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/common/EntryBookListRenderer.java $
 * %%
 * Copyright (C) 2012 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.common;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import org.chorem.lima.entity.EntryBook;

/**
 * EntryBook renderer for fiscal period retaining earning list.
 * 
 * @author chatellier
 * @version $Revision: 3585 $
 * 
 * Last update : $Date: 2012-08-08 16:52:14 +0200 (Wed, 08 Aug 2012) $
 * By : $Author: tchemit $
 */
public class EntryBookListRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -9089182547408397051L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        EntryBook entryBook = (EntryBook)value;
        Object newValue = entryBook;
        if (entryBook != null) {
            newValue = entryBook.getCode() + " - " + entryBook.getLabel();
        }
        return super.getListCellRendererComponent(list, newValue, index, isSelected,
                cellHasFocus);
    }
}
