package org.chorem.lima.ui.common;

/*
 * #%L
 * Lima :: Swing
 * $Id: AbstractLimaTable.java 3768 2014-04-11 13:38:02Z dcosse $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/common/AbstractLimaTable.java $
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.AccountTableCellRenderer;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateLimaTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.DefaultLimaTableCellRenderer;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.chorem.lima.ui.celleditor.EntryBookTableCellRender;
import org.chorem.lima.ui.celleditor.StringTableCellEditor;
import org.jdesktop.swingx.JXTable;

import javax.swing.*;
import javax.swing.table.TableCellEditor;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public abstract class AbstractLimaTable<H> extends JXTable {

    private static final Log log = LogFactory.getLog(AbstractLimaTable.class);

    protected H handler;

    public AbstractLimaTable(H handler) {
        this.handler = handler;

        setShowHorizontalLines(true);
        setShowVerticalLines(true);
        setGridColor(new Color(232, 232, 246));

        initNavigation();

        addMouseListener(new MyMouseAdapter());

        // renderer
        setDefaultRenderer(Object.class, new DefaultLimaTableCellRenderer());
        setDefaultRenderer(Date.class, new DateLimaTableCellRenderer());
        setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
        setDefaultRenderer(Account.class, new AccountTableCellRenderer());
        setDefaultRenderer(EntryBook.class, new EntryBookTableCellRender());

        // editor
        setDefaultEditor(Date.class, new DateTableCellEditor());
        setDefaultEditor(BigDecimal.class, new BigDecimalTableCellEditor());
        setDefaultEditor(Account.class, new AccountTableCellEditor());
        setDefaultEditor(EntryBook.class, new EntryBookTableCellEditor());
        setDefaultEditor(String.class, new StringTableCellEditor());

        setShowHorizontalLines(false);
    }

    protected void initNavigation() {

        InputMap inputMap= getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        ActionMap actionMap = getActionMap();

        // action on Tab
        Object binding = inputMap.get(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0));
        actionMap.put(binding, new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                clearSelection();
            }
        });


    }

    public H getHandler() {
        return handler;
    }

    public void exit() {
        if (isEditing()) {
            TableCellEditor editor = getCellEditor();
            editor.stopCellEditing();
        }
    }


    private class MyMouseAdapter extends MouseAdapter {

        @Override
        public void mousePressed(MouseEvent e) {
            if (rowAtPoint(e.getPoint()) == -1) {
                clearSelection();
            }
        }
    }


}
