/*
 * #%L
 * Lima Swing
 * 
 * $Id: DateTableCellEditor.java 3733 2014-01-03 14:36:55Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/celleditor/DateTableCellEditor.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.celleditor;

import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.jdesktop.swingx.JXDatePicker;

import javax.swing.*;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import java.awt.*;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/** @author ore */
public class DateTableCellEditor extends AbstractCellEditor
        implements TableCellEditor, FocusListener, AncestorListener {

    private static final Log log = LogFactory.getLog(DateTableCellEditor.class);

    private static final long serialVersionUID = 1L;

    private final JXDatePicker datePicker;
    //protected String comportmentEditingCell;

    //used to tell if the user has pressed a key
    private Date date;

    /** constructor */
    public DateTableCellEditor() {
        datePicker = new JXDatePicker(LimaContext.getContext().getConfig().getLocale());
        datePicker.getEditor().addFocusListener(this);
        datePicker.getEditor().addAncestorListener(this);
        datePicker.setFormats(
                DateFormat.getDateInstance(DateFormat.SHORT),
                new SimpleDateFormat("dd/MM/yyyy"),
                new SimpleDateFormat("dd/MM")
        );
        //comportmentEditingCell = LimaConfig.getInstance().getComportmentEditingCell();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Date) {
            datePicker.setDate((Date) value);
            date = (Date) value;
        }
        return datePicker;
    }

    @Override
    public Object getCellEditorValue() {
        if (log.isDebugEnabled()) {
            log.debug("getDate : input Date : " + datePicker.getDate() + "; text : " + datePicker.getEditor().getText());
        }
        try {
            datePicker.commitEdit();
        } catch (ParseException e) {
            e.printStackTrace();
        }

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(datePicker.getDate());
        int year = calendar.get(Calendar.YEAR);
        if (year == 1970) {
            calendar.setTime(date);
            year = calendar.get(Calendar.YEAR);
            Date newDate = DateUtils.setYears(datePicker.getDate(), year);
            datePicker.setDate(newDate);
        }

        if (log.isDebugEnabled()) {
            log.debug("getDate : output Date : " + datePicker.getDate());
        }
        return datePicker.getDate();
    }

    /*@Override
    public boolean isCellEditable(EventObject evt) {
        return !(evt instanceof MouseEvent) || ((MouseEvent) evt).getClickCount() == 2;
    } */

    @Override
    public void focusGained(FocusEvent e) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                JFormattedTextField dateFormattedTextField = datePicker.getEditor();
                LimaConfig config = LimaConfig.getInstance();
                if (config.isSelectAllEditingCell()) {
                    dateFormattedTextField.selectAll();
                } else {
                    int textFieldSize = dateFormattedTextField.getText().length();
                    dateFormattedTextField.select(textFieldSize, textFieldSize);
                }
            }
        });
    }

    public void focusLost(FocusEvent e) {
    }

    @Override
    public void ancestorAdded(AncestorEvent e) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                datePicker.requestFocus();
            }
        });
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }

}
