/*
 * #%L
 * Lima :: Swing
 * 
 * $Id: LimaRendererUtil.java 3733 2014-01-03 14:36:55Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/LimaRendererUtil.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui;

import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.chorem.lima.LimaContext;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.DecoratorProvider;

import javax.swing.*;

/**
 * Helper class to deal with renderers.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.5.2
 */
public class LimaRendererUtil {

    public static ListCellRenderer newDecoratorProviderListCellRenderer() {
        DecoratorProvider decoratorProvider = LimaContext.get().getDecoratorProvider();
        return new DecoratorProviderListCellRenderer(decoratorProvider);
    }

    public static ListCellRenderer newDecoratorListCellRenderer(Class<?> type) {

        DecoratorProvider decoratorProvider = LimaContext.get().getDecoratorProvider();
        Decorator<?> decorator = decoratorProvider.getDecoratorByType(type);
        return new DecoratorListCellRenderer(decorator);
    }

}
