/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.vatchart;

import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.api.VatStatementService;
import org.chorem.lima.entity.VatStatement;
import org.chorem.lima.entity.VatStatementImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.vatchart.VatChartViewHandler;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;

public class VatChartTreeTableModel
extends AbstractTreeTableModel {
    private static final Log log = LogFactory.getLog(VatChartViewHandler.class);
    protected final VatStatementService vatStatementService = (VatStatementService)LimaServiceFactory.getService(VatStatementService.class);

    public VatChartTreeTableModel() {
        super((Object)new VatStatementImpl());
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        String res = null;
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.table.label", (Object[])new Object[0]);
                break;
            }
            case 1: {
                res = I18n._((String)"lima.table.account", (Object[])new Object[0]);
            }
        }
        return res;
    }

    public int getChildCount(Object node) {
        int result = 0;
        if (node == this.getRoot()) {
            try {
                result = this.vatStatementService.getChildrenVatStatement(null).size();
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't count child", (Throwable)eee);
            }
        } else {
            VatStatement parentVatStatementHeader = (VatStatement)node;
            try {
                result = this.vatStatementService.getChildrenVatStatement(parentVatStatementHeader).size();
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't count child", (Throwable)eee);
            }
        }
        return result;
    }

    public Object getChild(Object parent, int index) {
        Object result = null;
        if (parent == this.getRoot()) {
            try {
                List vatStatements = this.vatStatementService.getChildrenVatStatement(null);
                result = vatStatements.get(index);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get child", (Throwable)eee);
            }
        } else {
            VatStatement parentVatStatement = (VatStatement)parent;
            try {
                List vatStatements = this.vatStatementService.getChildrenVatStatement(parentVatStatement);
                result = vatStatements.get(index);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get child", (Throwable)eee);
            }
        }
        return result;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int result = 0;
        if (parent == this.getRoot()) {
            try {
                List vatStatements = this.vatStatementService.getChildrenVatStatement(null);
                result = vatStatements.indexOf(child);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get index child", (Throwable)eee);
            }
        } else {
            VatStatement parentVatStatement = (VatStatement)parent;
            try {
                List vatStatements = this.vatStatementService.getChildrenVatStatement(parentVatStatement);
                result = vatStatements.indexOf(child);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get index child", (Throwable)eee);
            }
        }
        return result;
    }

    public Object getValueAt(Object node, int column) {
        String result = "n/a";
        VatStatement vatStatement = (VatStatement)node;
        switch (column) {
            case 0: {
                result = vatStatement.getLabel();
                break;
            }
            case 1: {
                result = vatStatement.getAccounts();
            }
        }
        return result;
    }

    public boolean isCellEditable(Object node, int column) {
        return column == 1 && this.isLeaf(node);
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void refreshTree() throws LimaException {
        this.modelSupport.fireNewRoot();
    }

    public void addVatStatement(TreePath path, VatStatement vatStatement) throws LimaException {
        VatStatement parentVatStatementHeader = null;
        if (path != null) {
            parentVatStatementHeader = (VatStatement)path.getLastPathComponent();
        }
        this.vatStatementService.createVatStatement(parentVatStatementHeader, vatStatement);
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void updateVatStatement(TreePath path, VatStatement vatStatement) throws LimaException {
        this.vatStatementService.updateVatStatement(vatStatement);
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void removeVatStatementObject(TreePath path, VatStatement vatStatement) throws LimaException {
        int index = this.getIndexOfChild(path.getParentPath().getLastPathComponent(), vatStatement);
        this.vatStatementService.removeVatStatement(vatStatement);
        this.modelSupport.fireChildRemoved(path.getParentPath(), index, (Object)vatStatement);
    }

    public void setValueAt(Object value, Object node, int column) {
        VatStatement vatStatement = (VatStatement)node;
        vatStatement.setAccounts((String)value);
        try {
            this.vatStatementService.updateVatStatement(vatStatement);
        }
        catch (LimaException eee) {
            log.debug((Object)"Can't update vatStatement", (Throwable)eee);
        }
    }
}

