/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.importexport;

import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.api.ExportService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.utils.ImportExportEntityEnum;
import org.chorem.lima.enums.EncodingEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.importexport.ImportExportWaitView;
import org.jdesktop.swingx.painter.BusyPainter;
import org.nuiton.i18n.I18n;

public class ImportExport {
    private static final Log log = LogFactory.getLog(ImportExport.class);
    protected Component viewComponent;
    protected EncodingEnum encodingEnum;
    protected ImportService importService;
    protected ExportService exportService;
    private ImportExportWaitView waitView;

    public ImportExport(Component view) {
        this.viewComponent = view;
        this.importService = (ImportService)LimaServiceFactory.getService(ImportService.class);
        this.exportService = (ExportService)LimaServiceFactory.getService(ExportService.class);
        this.waitView = new ImportExportWaitView();
        this.waitView.waitDialog.setSize(400, 200);
        this.waitView.setLocationRelativeTo(view);
        BusyPainter busyPainter = this.waitView.getBusylabel().getBusyPainter();
        busyPainter.setHighlightColor(new Color(44, 61, 146).darker());
        busyPainter.setBaseColor(new Color(168, 204, 241).brighter());
    }

    public void importExport(ImportExportEnum importExportMethode, String file, boolean verbose) {
        final ImportExportEnum importExportMethodeF = importExportMethode;
        this.encodingEnum = EncodingEnum.UTF8;
        if (Strings.isNullOrEmpty((String)file)) {
            file = this.chooseFile(importExportMethode.getImportMode(), importExportMethode);
        }
        if (!Strings.isNullOrEmpty((String)file)) {
            final EncodingEnum charset = this.encodingEnum;
            final String filePath = file;
            final Boolean verboseMode = verbose;
            final Boolean importMode = importExportMethode.getImportMode();
            new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() {
                    String result = "";
                    switch (importExportMethodeF) {
                        case CSV_ALL_EXPORT: {
                            String datas = ImportExport.this.exportService.exportAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case CSV_ACCOUNTCHARTS_EXPORT: {
                            String datas = ImportExport.this.exportService.exportAccountsChartAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case CSV_ENTRYBOOKS_EXPORT: {
                            String datas = ImportExport.this.exportService.exportEntryBookChartAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case CSV_FINANCIALSTATEMENTS_EXPORT: {
                            String datas = ImportExport.this.exportService.exportFinancialStatementChartAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case CSV_VAT_EXPORT: {
                            String datas = ImportExport.this.exportService.exportVatStatementChartAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case EBP_ACCOUNTCHARTS_EXPORT: {
                            String datas = ImportExport.this.exportService.exportAccountsAsEBP();
                            ImportExport.this.createFile(filePath, EncodingEnum.ISOLATIN1.getEncoding(), datas);
                            break;
                        }
                        case EBP_ENTRIES_EXPORT: {
                            String datas = ImportExport.this.exportService.exportEntriesAsEBP();
                            ImportExport.this.createFile(filePath, EncodingEnum.ISOLATIN1.getEncoding(), datas);
                            break;
                        }
                        case CSV_ALL_IMPORT: {
                            String datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAllAsCSV(datas);
                            break;
                        }
                        case CSV_ACCOUNTCHARTS_IMPORT: {
                            String datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsCSV(datas, ImportExportEntityEnum.ACCOUNT);
                            break;
                        }
                        case CSV_ENTRYBOOKS_IMPORT: {
                            String datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsCSV(datas, ImportExportEntityEnum.ENTRYBOOK);
                            break;
                        }
                        case CSV_FINANCIALSTATEMENTS_IMPORT: {
                            String datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsCSV(datas, ImportExportEntityEnum.FINANCIALSTATEMENT);
                            break;
                        }
                        case CSV_VAT_IMPORT: {
                            String datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsCSV(datas, ImportExportEntityEnum.VATSTATEMENT);
                            break;
                        }
                        case CSV_ENTRIES_IMPORT: {
                            String datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsCSV(datas, ImportExportEntityEnum.ENTRY);
                            break;
                        }
                        case PDF_VAT_IMPORT: {
                            int response = JOptionPane.showConfirmDialog(ImportExport.this.waitView, I18n._((String)"lima.importexport.usevatpdf", (Object[])new Object[0]), I18n._((String)"lima.common.confirmation", (Object[])new Object[0]), 0);
                            String datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsPDF(filePath, ImportExportEntityEnum.VATPDF, response == 0);
                            break;
                        }
                        case EBP_ACCOUNTCHARTS_IMPORT: {
                            String datas = ImportExport.this.extractFile(filePath, EncodingEnum.ISOLATIN1.getEncoding());
                            result = ImportExport.this.importService.importAccountsChartFromEbp(datas);
                            break;
                        }
                        case EBP_ENTRIES_IMPORT: {
                            String datas = ImportExport.this.extractFile(filePath, EncodingEnum.ISOLATIN1.getEncoding());
                            result = ImportExport.this.importService.importEntriesFromEbp(datas);
                        }
                    }
                    return result;
                }

                @Override
                protected void done() {
                    block16: {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("importMode : " + importMode));
                            }
                            ImportExport.this.waitView.setVisible(false);
                            if (verboseMode.booleanValue()) {
                                String result = (String)this.get();
                                if (result.equals(null)) {
                                    JOptionPane.showMessageDialog(ImportExport.this.viewComponent, I18n._((String)"lima.ui.importexport.importerror", (Object[])new Object[0]), I18n._((String)"lima.ui.importexport.importtitle", (Object[])new Object[0]), 0);
                                } else if (importMode.booleanValue()) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"importMode");
                                        log.debug((Object)("importExportMethodeF : " + (Object)((Object)importExportMethodeF)));
                                    }
                                    if (importExportMethodeF.equals((Object)ImportExportEnum.PDF_VAT_IMPORT)) {
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)"PDF_VAT_IMPORT");
                                        }
                                        JOptionPane.showMessageDialog(ImportExport.this.waitView, I18n._((String)"lima.ui.importexport.import.vatpdfimport", (Object[])new Object[0]), I18n._((String)"lima.ui.importexport.import", (Object[])new Object[0]), 1);
                                    } else {
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)"import.terminated");
                                        }
                                        JOptionPane.showMessageDialog(ImportExport.this.waitView, I18n._((String)"lima.ui.importexport.import.terminated", (Object[])new Object[0]), I18n._((String)"lima.ui.importexport.import", (Object[])new Object[0]), 1);
                                    }
                                } else {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"export.terminated");
                                    }
                                    JOptionPane.showMessageDialog(ImportExport.this.waitView, I18n._((String)"lima.ui.importexport.export.terminated", (Object[])new Object[0]), I18n._((String)"lima.ui.importexport.export", (Object[])new Object[0]), 1);
                                }
                            }
                        }
                        catch (InterruptedException ex) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"Can't get result message", (Throwable)ex);
                            }
                        }
                        catch (ExecutionException ex) {
                            if (!log.isErrorEnabled()) break block16;
                            log.error((Object)"Can't get result message", (Throwable)ex);
                        }
                    }
                }
            }.execute();
            this.waitView.setVisible(true);
        }
    }

    public String chooseFile(Boolean importMode, ImportExportEnum importExportMethode) {
        String approveButtonText;
        String filePath = "";
        JFileChooser chooser = new JFileChooser();
        JComboBox<String> comboBox = new JComboBox<String>(EncodingEnum.descriptions());
        if (importExportMethode.getEncodingOption().booleanValue()) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JLabel(I18n._((String)"lima.importexport.choiceencoding", (Object[])new Object[0])), "West");
            panel.add(comboBox, "Center");
            ((Container)chooser.getComponent(2)).add((Component)panel, "South");
        }
        if (importMode.booleanValue()) {
            chooser.setFileSelectionMode(0);
            approveButtonText = I18n._((String)"lima.ui.importexport.import", (Object[])new Object[0]);
            chooser.setDialogTitle(approveButtonText);
            chooser.setApproveButtonText(approveButtonText);
        } else {
            approveButtonText = I18n._((String)"lima.ui.importexport.export", (Object[])new Object[0]);
            chooser.setFileSelectionMode(2);
            chooser.setDialogTitle(approveButtonText);
            chooser.setApproveButtonText(approveButtonText);
        }
        if (chooser.showOpenDialog(this.viewComponent) == 0) {
            filePath = chooser.getSelectedFile().getAbsolutePath();
            if (importExportMethode.getEncodingOption().booleanValue()) {
                this.encodingEnum = EncodingEnum.valueOfDescription((String)comboBox.getSelectedItem());
            }
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(String filePath, String charset, String datas) {
        File file = new File(filePath);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
            out.write(datas);
            out.flush();
            out.close();
            IOUtils.closeQuietly((Writer)out);
        }
        catch (IOException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't write file " + filePath), (Throwable)eee);
            }
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String extractFile(String filePath, String charset) {
        StringWriter sw = new StringWriter();
        BufferedReader in = null;
        try {
            InputStream is;
            if (filePath != null && filePath.indexOf(".jar!") > 0) {
                String resourcesPath = filePath.substring(filePath.indexOf(".jar!") + 5);
                is = ImportExport.class.getResourceAsStream(resourcesPath);
            } else {
                is = new FileInputStream(filePath);
            }
            in = new BufferedReader(new InputStreamReader(is, charset));
            IOUtils.copy((Reader)in, (Writer)sw);
            in.close();
            IOUtils.closeQuietly((Reader)in);
        }
        catch (IOException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't read file " + filePath), (Throwable)eee);
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return sw.toString();
    }
}

