/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.home;

import javax.swing.event.HyperlinkEvent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.home.AbstractHomePane;
import org.chorem.lima.ui.home.HomeView;
import org.nuiton.i18n.I18n;

public class AccountsPane
extends AbstractHomePane
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AccountsPane.class);
    protected AccountService accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);

    public AccountsPane(HomeView view) {
        super(view);
        LimaServiceFactory.addServiceListener(AccountService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && e.getDescription().equals("#accountschart")) {
            MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
            ui.getHandler().showAccountView((JAXXContext)ui);
        }
    }

    public void refresh() {
        block4: {
            log.debug((Object)"Rafra\u00eechissement accounts pane");
            String htmlBegin = "<font face='sans-serif' size=3><p style=vertical-align:'bottom', horizontal-align:'center'>";
            String htmlEnd = "</p></font>";
            try {
                long accountCount = this.accountService.getAccountCount();
                if (accountCount > 0L) {
                    this.setBackground(GREEN_BACKGROUND);
                    String accountsString = I18n._((String)"lima.ui.home.chartaccounts.state1_2", (Object[])new Object[0]) + " " + accountCount + " " + I18n._((String)"lima.ui.home.chartaccounts.state2_2", (Object[])new Object[0]) + "<br/><br/><a href='#accountschart'>" + I18n._((String)"lima.ui.home.chartaccounts.modify", (Object[])new Object[0]) + "</a>";
                    this.setText(htmlBegin + accountsString + htmlEnd);
                } else {
                    this.setBackground(RED_BACKGROUND);
                    String accountsString = I18n._((String)"lima.ui.home.chartaccounts.nothing", (Object[])new Object[0]) + "<br/><br/><a href='#accountschart'>" + I18n._((String)"lima.ui.home.chartaccounts.create", (Object[])new Object[0]) + "</a>";
                    this.setText(htmlBegin + accountsString + htmlEnd);
                }
            }
            catch (LimaException ex) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Can't get datas account editor pane home", (Throwable)ex);
            }
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        log.debug((Object)("Nom de la m\u00e9thode : " + methodeName));
        if (methodeName.contains("Account") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.refresh();
        }
    }
}

