/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.math.BigDecimal;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.common.AbstractColumn;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class DebitColumn
extends AbstractColumn<FinancialTransactionTableModel> {
    public DebitColumn() {
        super(BigDecimal.class, I18n._((String)"lima.ui.financialtransaction.debit", (Object[])new Object[0]), true);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = (Entry)((FinancialTransactionTableModel)this.tableModel).get(row);
        return entry.getDebit() ? entry.getAmount() : BigDecimal.ZERO;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        boolean update;
        Entry entry = (Entry)((FinancialTransactionTableModel)this.tableModel).get(row);
        BigDecimal debit = (BigDecimal)value;
        boolean bl = update = debit.signum() > 0 && (!entry.isDebit() || entry.getAmount().compareTo(debit) != 0);
        if (update) {
            entry.setAmount(debit);
            entry.setDebit(true);
            ((FinancialTransactionTableModel)this.tableModel).updateEntry(entry);
            ((FinancialTransactionTableModel)this.tableModel).fireTransaction(entry.getFinancialTransaction());
        }
        return update;
    }
}

