/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementreport;

import java.math.BigDecimal;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.chorem.lima.beans.FinancialStatementAmounts;
import org.nuiton.i18n.I18n;

public class FinancialStatementReportTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected List<FinancialStatementAmounts> financialStatementAmounts;

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.financialStatementAmounts != null) {
            result = this.financialStatementAmounts.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = BigDecimal.class;
                break;
            }
            case 2: {
                result = BigDecimal.class;
                break;
            }
            case 3: {
                result = BigDecimal.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.table.label", (Object[])new Object[0]);
                break;
            }
            case 1: {
                res = I18n._((String)"lima.table.grossamount", (Object[])new Object[0]);
                break;
            }
            case 2: {
                res = I18n._((String)"lima.table.provisiondeprecationamount", (Object[])new Object[0]);
                break;
            }
            case 3: {
                res = I18n._((String)"lima.table.netamount", (Object[])new Object[0]);
            }
        }
        return res;
    }

    public Object getElementAt(int row) {
        FinancialStatementAmounts currentRow = this.financialStatementAmounts.get(row);
        return currentRow;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = this.financialStatementAmounts.get(row);
        if (result instanceof FinancialStatementAmounts) {
            BigDecimal provisionDeprecationAmount;
            FinancialStatementAmounts currentRow = result;
            BigDecimal grossAmount = currentRow.getGrossAmount();
            if (grossAmount == null) {
                grossAmount = BigDecimal.ZERO;
            }
            if ((provisionDeprecationAmount = currentRow.getProvisionDeprecationAmount()) == null) {
                provisionDeprecationAmount = BigDecimal.ZERO;
            }
            switch (column) {
                case 0: {
                    result = "";
                    String label = currentRow.getLabel();
                    if (label == null) break;
                    for (int i = 0; i <= currentRow.getLevel(); ++i) {
                        result = result + "\t";
                    }
                    result = result + label;
                    break;
                }
                case 1: {
                    if (grossAmount.compareTo(BigDecimal.ZERO) == 0) {
                        result = null;
                        break;
                    }
                    result = grossAmount;
                    break;
                }
                case 2: {
                    if (provisionDeprecationAmount.compareTo(BigDecimal.ZERO) == 0) {
                        result = null;
                        break;
                    }
                    result = provisionDeprecationAmount;
                    break;
                }
                case 3: {
                    BigDecimal solde = grossAmount.subtract(provisionDeprecationAmount);
                    result = solde.compareTo(BigDecimal.ZERO) == 0 ? null : solde;
                }
            }
        }
        return result;
    }

    public void setFinancialStatementAmounts(List<FinancialStatementAmounts> financialStatementAmounts) {
        this.financialStatementAmounts = financialStatementAmounts;
        this.fireTableDataChanged();
    }
}

