/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.common;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.AccountTableCellRenderer;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateLimaTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.DefaultLimaTableCellRenderer;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.chorem.lima.ui.celleditor.EntryBookTableCellRender;
import org.chorem.lima.ui.celleditor.StringTableCellEditor;
import org.jdesktop.swingx.JXTable;

public abstract class AbstractLimaTable<H>
extends JXTable {
    private static final Log log = LogFactory.getLog(AbstractLimaTable.class);
    protected H handler;

    public AbstractLimaTable(H handler) {
        this.handler = handler;
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setGridColor(new Color(232, 232, 246));
        this.initNavigation();
        this.addMouseListener(new MyMouseAdapter());
        this.setDefaultRenderer(Object.class, new DefaultLimaTableCellRenderer());
        this.setDefaultRenderer(Date.class, new DateLimaTableCellRenderer());
        this.setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
        this.setDefaultRenderer(Account.class, new AccountTableCellRenderer());
        this.setDefaultRenderer(EntryBook.class, new EntryBookTableCellRender());
        this.setDefaultEditor(Date.class, new DateTableCellEditor());
        this.setDefaultEditor(BigDecimal.class, new BigDecimalTableCellEditor());
        this.setDefaultEditor(Account.class, new AccountTableCellEditor());
        this.setDefaultEditor(EntryBook.class, new EntryBookTableCellEditor());
        this.setDefaultEditor(String.class, new StringTableCellEditor());
        this.setShowHorizontalLines(false);
    }

    protected void initNavigation() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        Object binding = inputMap.get(KeyStroke.getKeyStroke(27, 0));
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLimaTable.this.clearSelection();
            }
        });
    }

    public H getHandler() {
        return this.handler;
    }

    public void exit() {
        if (this.isEditing()) {
            TableCellEditor editor = this.getCellEditor();
            editor.stopCellEditing();
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (AbstractLimaTable.this.rowAtPoint(e.getPoint()) == -1) {
                AbstractLimaTable.this.clearSelection();
            }
        }
    }
}

