/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.accountsreports;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.business.api.ReportService;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.entity.Account;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.accountsreports.AccountsReportsView;

public class AccountsReportsViewHandler {
    protected AccountsReportsView view;
    protected ReportService reportService;
    protected AccountService accountService;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;
    private static final Log log = LogFactory.getLog(AccountsReportsViewHandler.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    protected AccountsReportsViewHandler(AccountsReportsView view) {
        this.view = view;
        this.reportService = (ReportService)LimaServiceFactory.getService(ReportService.class);
        this.accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
    }

    public void init() {
        List account = this.accountService.getAllAccounts();
        this.view.getAccountComboboxModel().setObjects(account);
        List fiscalPeriod = this.fiscalPeriodService.getAllFiscalPeriods();
        List financialPeriod = this.financialPeriodService.getUnblockedFinancialPeriods();
        this.view.getIntervalPanel().init(fiscalPeriod, financialPeriod);
    }

    public void createDocument() {
        Date beginDate = this.view.getIntervalPanel().getBeginDate();
        Date endDate = this.view.getIntervalPanel().getEndDate();
        Account account = (Account)this.view.getAccountComboBox().getModel().getSelectedItem();
        if (beginDate != null && endDate != null && account != null) {
            int port = ((HttpServerService)LimaServiceFactory.getService(HttpServerService.class)).getHttpPort();
            String address = LimaConfig.getInstance().getHostAdress();
            try {
                String url = "http://" + address + ":" + port + "/?beginDate=" + dateFormat.format(beginDate) + "&endDate=" + dateFormat.format(endDate) + "&account=" + URLEncoder.encode(account.getTopiaId(), "UTF-8") + "&format=.html&model=" + DocumentsEnum.ACCOUNT.getFileName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("URL : " + url));
                }
                URI uri = URI.create(url);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("URI : " + uri));
                }
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                log.error((Object)"Can't open browser", (Throwable)e);
            }
        }
    }
}

