/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.actions.MiscAction;
import org.chorem.lima.business.api.OptionsService;
import org.chorem.lima.entity.LimaCallaoDAOHelper;
import org.chorem.lima.service.LimaServiceFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;
import org.nuiton.util.converter.ConverterUtil;

public class LimaConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(LimaConfig.class);
    public static final Set<Character> NUMBER_SEPARATOR = ImmutableSet.of((Object)Character.valueOf(' '), (Object)Character.valueOf(','), (Object)Character.valueOf('.'), (Object)Character.valueOf(';'));
    public static final Set<Integer> NUMBER_DECIMALS = ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object[])new Integer[]{6});
    protected static LimaConfig instance;
    private static final String configFile = "lima-config.properties";
    protected OptionsService optionsService;
    protected Version version;
    public static final String[] DEFAULT_JAXX_PCS;

    public String getCopyrightText() {
        return "Version " + this.getVersion() + " Codelutin @ 2008-2012";
    }

    public String getVersion() {
        return this.version.toString();
    }

    public LimaConfig() {
        this.loadDefaultOptions(Option.values());
        for (Action a : Action.values()) {
            for (String alias : a.aliases) {
                this.addActionAlias(alias, a.action);
            }
        }
        this.addAlias("--disableui", new String[]{"--launchui false"});
    }

    public static LimaConfig getInstance() {
        if (instance == null) {
            instance = new LimaConfig();
            instance.loadConfiguration(configFile);
        }
        return instance;
    }

    protected void loadConfiguration(String configFileName) {
        block2: {
            instance.setConfigFileName(configFileName);
            try {
                instance.parse(new String[0]);
            }
            catch (ArgumentsParserException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't read configuration", (Throwable)ex);
            }
        }
        instance.setOption("topia.persistence.classes", LimaCallaoDAOHelper.getImplementationClassesAsString());
    }

    public ApplicationConfig parse(String ... args) throws ArgumentsParserException {
        super.parse(args);
        String sVersion = VersionUtil.removeSnapshot((String)this.getOption("application.version"));
        this.version = VersionUtil.valueOf((String)sVersion);
        return this;
    }

    public Locale getLocale() {
        String local = this.getOption(Option.LOCALE.key);
        Locale result = (Locale)ConverterUtil.convert(Locale.class, (Object)local);
        return result;
    }

    public void setLocale(String locale) {
        this.setOption(Option.LOCALE.key, locale);
    }

    public void setLocale(Locale newLocale) {
        this.setOption(Option.LOCALE.key, newLocale.toString());
        this.saveForUser(new String[0]);
        this.firePropertyChange("locale", null, newLocale);
    }

    public char getDecimalSeparator() {
        char decimalSeparator = this.getOption(Option.DECIMAL_SEPARATOR.key).charAt(0);
        return decimalSeparator;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.setOption(Option.DECIMAL_SEPARATOR.key, decimalSeparator);
        this.saveForUser(new String[0]);
        this.firePropertyChange("decimalSeparator", null, decimalSeparator);
    }

    public int getScale() {
        return this.getOptionAsInt(Option.SCALE.key);
    }

    public void setScale(String scale) {
        this.setOption(Option.SCALE.key, scale);
        this.saveForUser(new String[0]);
        this.firePropertyChange("scale", null, scale);
        if (log.isInfoEnabled()) {
            log.info((Object)("new scale" + scale));
        }
        this.optionsService.setScale(scale);
    }

    public char getThousandSeparator() {
        return this.getOption(Option.THOUSAND_SEPARATOR.key).charAt(0);
    }

    public void setThousandSeparator(String thousandSeparator) {
        this.setOption(Option.THOUSAND_SEPARATOR.key, thousandSeparator);
        this.saveForUser(new String[0]);
        this.firePropertyChange("thousandSeparator", null, thousandSeparator);
    }

    public boolean getCurrency() {
        return this.getOptionAsBoolean(Option.CURRENCY.key);
    }

    public void setCurrency(boolean currency) {
        this.setOption(Option.CURRENCY.key, Boolean.toString(currency));
        this.saveForUser(new String[0]);
        this.firePropertyChange("currency", null, currency);
    }

    public boolean isLaunchui() {
        boolean launchUI = this.getOptionAsBoolean(Option.LAUNCH_UI.key);
        return launchUI;
    }

    public void setLaunchui(String launchui) {
        this.setOption(Option.LAUNCH_UI.key, launchui);
    }

    public void setFullscreen(boolean fullscreen) {
        boolean oldValue = this.isFullScreen();
        this.setOption(Option.FULL_SCREEN.key, fullscreen + "");
        this.saveForUser(new String[0]);
        this.firePropertyChange("fullscreen", oldValue, fullscreen);
    }

    public boolean isFullScreen() {
        Boolean result = this.getOptionAsBoolean(Option.FULL_SCREEN.key);
        return result != null && result != false;
    }

    public String getSupportEmail() {
        return this.getOption(Option.SUPPORT_EMAIL.key);
    }

    public boolean isEJBRemoteMode() {
        boolean result = this.getOptionAsBoolean(Option.OPENEJB_REMOTEMODE.key);
        return result;
    }

    public File getDataDirectory() {
        File result = this.getOptionAsFile(Option.DATA_DIR.key);
        return result;
    }

    public File getLimaStateFile() {
        File result = this.getOptionAsFile(Option.LIMA_STATE_FILE.key);
        return result;
    }

    public File getResourcesDirectory() {
        File result = this.getOptionAsFile(Option.RESOURCES_DIRECTORY.key);
        return result;
    }

    public File getI18nDirectory() {
        File result = this.getOptionAsFile(Option.I18N_DIRECTORY.key);
        return result;
    }

    public String getHostAdress() {
        return this.getOption(Option.LIMA_HOST_ADDRESS.key);
    }

    public void setColorSelectionFocus(String color) {
        this.setOption(Option.COLOR_SELECTION_FOCUS.key, color);
    }

    public Color getColorSelectionFocus() {
        return this.getOptionAsColor(Option.COLOR_SELECTION_FOCUS.key);
    }

    public void setSelectAllEditingCell(boolean selectAllEditingCell) {
        this.setOption(Option.SELECT_ALL_EDITING_CELL.key, Boolean.toString(selectAllEditingCell));
    }

    public boolean isSelectAllEditingCell() {
        return this.getOptionAsBoolean(Option.SELECT_ALL_EDITING_CELL.key);
    }

    public void removeJaxxPropertyChangeListener() {
        PropertyChangeListener[] toRemove = JAXXUtil.findJaxxPropertyChangeListener((String[])DEFAULT_JAXX_PCS, (PropertyChangeListener[])this.getPropertyChangeListeners());
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before remove : " + this.getPropertyChangeListeners().length));
            log.debug((Object)("toRemove : " + toRemove.length));
        }
        for (PropertyChangeListener listener : toRemove) {
            this.removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after remove : " + this.getPropertyChangeListeners().length));
        }
    }

    public void save(File file, boolean forceAll, String ... excludeKeys) throws IOException {
        super.save(file, forceAll, excludeKeys);
        this.optionsService = (OptionsService)LimaServiceFactory.getService(OptionsService.class);
        String scaleOption = this.getOption("scale");
        if (StringUtils.isNotBlank((CharSequence)scaleOption)) {
            this.optionsService.setScale(scaleOption);
        }
    }

    static {
        DEFAULT_JAXX_PCS = new String[]{"fullScreen", "locale", "decimalSeparator", "scale", "thousandSeparator", "currency"};
    }

    public static enum Action {
        HELP(I18n.n_((String)"lima.action.commandline.help", (Object[])new Object[0]), MiscAction.class.getName() + "#help", "-h", "--help");

        public static final int BEFORE_EXIT_STEP = 0;
        public static final int AFTER_INIT_STEP = 1;
        public String description;
        public String action;
        public String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }

        public String getDescription() {
            return I18n._((String)this.description, (Object[])new Object[0]);
        }
    }

    public static enum Option implements ConfigOptionDef
    {
        CONFIG_FILE("config.file", I18n._((String)"lima.config.configFileName.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.configFileName.description", (Object[])new Object[0]), "lima-config.properties", String.class, true, true),
        DATA_DIR("lima.data.dir", I18n._((String)"lima.config.data.dir.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.data.dir.description", (Object[])new Object[0]), "${user.home}/.lima", File.class, false, false),
        RESOURCES_DIRECTORY("lima.resources.dir", I18n._((String)"lima.config.resources.dir.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.resources.dir.description", (Object[])new Object[0]), "${lima.data.dir}/resources-${application.version}", String.class, false, false),
        I18N_DIRECTORY("lima.i18n.dir", I18n._((String)"lima.config.i18n.dir.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.i18n.dir.description", (Object[])new Object[0]), "${lima.resources.dir}/i18n", String.class, false, false),
        LOCALE("lima.ui.locale", I18n._((String)"lima.config.locale.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.locale.description", (Object[])new Object[0]), "fr_FR", Locale.class, false, false),
        DECIMAL_SEPARATOR("lima.data.bigDecimal.decimalSeparator", I18n._((String)"lima.config.decimalseparator.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.decimalseparator.description", (Object[])new Object[0]), ",", Character.class, false, false),
        SCALE("lima.data.bigDecimal.scale", I18n._((String)"lima.config.scale.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.scale.description", (Object[])new Object[0]), "2", Integer.class, false, false),
        THOUSAND_SEPARATOR("lima.thousandSeparator", I18n._((String)"limma.config.thousandseparator.label", (Object[])new Object[0]), I18n.n_((String)"limma.config.thousandseparator.description", (Object[])new Object[0]), " ", Character.class, false, false),
        CURRENCY("lima.config.currency", I18n._((String)"lima.config.currency.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.currency.description", (Object[])new Object[0]), "false", Boolean.class, false, false),
        FULL_SCREEN("lima.ui.fullscreen", I18n._((String)"lima.config.ui.fullscreen.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.ui.fullscreen.description", (Object[])new Object[0]), "false", Boolean.class, false, false),
        LAUNCH_UI("lima.ui.launchui", I18n._((String)"lima.config.ui.flaunchui.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.ui.flaunchui.description", (Object[])new Object[0]), "true", Boolean.class, true, true),
        SUPPORT_EMAIL("lima.misc.supportemail", I18n._((String)"lima.misc.supportemail.label", (Object[])new Object[0]), I18n.n_((String)"lima.misc.supportemail.description", (Object[])new Object[0]), "support@codelutin.com", String.class, false, false),
        OPENEJB_REMOTEMODE("lima.openejb.remotemode", I18n._((String)"lima.openejb.remotemode.label", (Object[])new Object[0]), I18n.n_((String)"lima.openejb.remotemode.description", (Object[])new Object[0]), "false", String.class, false, false),
        LIMA_HOST_ADDRESS("lima.host.address", I18n._((String)"lima.config.host.adress.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.host.adress.description", (Object[])new Object[0]), "localhost", String.class, false, false),
        LIMA_STATE_FILE("lima.ui.state.file", I18n._((String)"lima.config.state.file.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.state.file.description", (Object[])new Object[0]), "${lima.data.dir}/limaState.xml", String.class, false, false),
        COLOR_SELECTION_FOCUS("lima.ui.table.cell.colorSelectionFocus", I18n._((String)"lima.config.colorselectionfocus.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.colorselectionfocus.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        SELECT_ALL_EDITING_CELL("lima.ui.table.cell.selectAllEditingCell", I18n._((String)"lima.config.selectAllEditingCell.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.selectAllEditingCell.description", (Object[])new Object[0]), "true", Boolean.class, false, false),
        TABLE_CELL_BACKGROUND("lima.ui.table.cell.background", I18n._((String)"lima.config.cell.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.background.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_FOREGROUND("lima.ui.table.cell.foreground", I18n._((String)"lima.config.cell.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        TABLE_CELL_PAIR_BACKGROUND("lima.ui.table.cell.pair.background", I18n._((String)"lima.config.cell.pair.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.background.description", (Object[])new Object[0]), "#EEEEEE", Color.class, false, false),
        TABLE_CELL_PAIR_FOREGROUND("lima.ui.table.cell.pair.foreground", I18n._((String)"lima.config.cell.pair.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        TABLE_CELL_SELECTED_BACKGROUND("lima.ui.table.cell.selected.background", I18n._((String)"lima.config.cell.selected.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.selected.background.description", (Object[])new Object[0]), "#0066CC", Color.class, false, false),
        TABLE_CELL_SELECTED_FOREGROUND("lima.ui.table.cell.selected.foreground", I18n._((String)"lima.config.cell.selected.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.selected.foreground.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_BACKGROUND("lima.ui.table.cell.pair.selected.background", I18n._((String)"lima.config.cell.pair.selected.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.selected.background.description", (Object[])new Object[0]), "#006699", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_FOREGROUND("lima.ui.table.cell.pair.selected.foreground", I18n._((String)"lima.config.cell.pair.selected.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.selected.foreground.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_ERROR_BACKGROUND("lima.ui.table.cell.error.background", I18n._((String)"lima.config.cell.error.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.error.background.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_ERROR_FOREGROUND("lima.ui.table.cell.error.foreground", I18n._((String)"lima.config.cell.error.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.error.foreground.description", (Object[])new Object[0]), "#FF0936", Color.class, false, false),
        TABLE_CELL_PAIR_ERROR_BACKGROUND("lima.ui.table.cell.pair.error.background", I18n._((String)"lima.config.cell.pair.error.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.error.background.description", (Object[])new Object[0]), "#EEEEEE", Color.class, false, false),
        TABLE_CELL_PAIR_ERROR_FOREGROUND("lima.ui.table.cell.pair.error.foreground", I18n._((String)"lima.config.cell.pair.error.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.error.foreground.description", (Object[])new Object[0]), "#FC0625", Color.class, false, false),
        TABLE_CELL_SELECTED_ERROR_BACKGROUND("lima.ui.table.cell.selected.error.background", I18n._((String)"lima.config.cell.selected.error.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.selected.error.background.description", (Object[])new Object[0]), "#0066CC", Color.class, false, false),
        TABLE_CELL_SELECTED_ERROR_FOREGROUND("lima.ui.table.cell.selected.error.foreground", I18n._((String)"lima.config.cell.selected.error.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.selected.error.foreground.description", (Object[])new Object[0]), "#C998C1", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_ERROR_BACKGROUND("lima.ui.table.cell.pair.selected.error.background", I18n._((String)"lima.config.cell.pair.selected.error.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.selected.error.background.description", (Object[])new Object[0]), "#006699", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_ERROR_FOREGROUND("lima.ui.table.cell.pair.selected.error.foreground", I18n._((String)"lima.config.cell.pair.selected.error.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.selected.error.foreground.description", (Object[])new Object[0]), "#C96678", Color.class, false, false),
        TABLE_CELL_MANDATORY_BACKGROUND("lima.ui.table.cell.mandatory.background", I18n._((String)"lima.config.cell.mandatory.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.mandatory.background.description", (Object[])new Object[0]), "#FFCCCC", Color.class, false, false),
        TABLE_CELL_MANDATORY_FOREGROUND("lima.ui.table.cell.mandatory.foreground", I18n._((String)"lima.config.cell.mandatory.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.mandatory.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        TABLE_CELL_PAIR_MANDATORY_BACKGROUND("lima.ui.table.cell.pair.mandatory.background", I18n._((String)"lima.config.cell.pair.mandatory.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.mandatory.background.description", (Object[])new Object[0]), "#FF99CC", Color.class, false, false),
        TABLE_CELL_PAIR_MANDATORY_FOREGROUND("lima.ui.table.cell.pair.mandatory.foreground", I18n._((String)"lima.config.cell.pair.mandatory.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.mandatory.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        TABLE_CELL_SELECTED_MANDATORY_BACKGROUND("lima.ui.table.cell.selected.mandatory.background", I18n._((String)"lima.config.cell.selected.mandatory.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.selected.mandatory.background.description", (Object[])new Object[0]), "#FF0000", Color.class, false, false),
        TABLE_CELL_SELECTED_MANDATORY_FOREGROUND("lima.ui.table.cell.selected.mandatory.foreground", I18n._((String)"lima.config.cell.selected.mandatory.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.selected.mandatory.foreground.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_MANDATORY_BACKGROUND("lima.ui.table.cell.pair.selected.mandatory.background", I18n._((String)"lima.config.cell.pair.selected.mandatory.background.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.selected.mandatory.background.description", (Object[])new Object[0]), "#990000", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_MANDATORY_FOREGROUND("lima.ui.table.cell.pair.selected.mandatory.foreground", I18n._((String)"lima.config.cell.pair.selected.mandatory.foreground.label", (Object[])new Object[0]), I18n.n_((String)"lima.config.cell.pair.selected.mandatory.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false);

        public final String key;
        public final String label;
        public final String description;
        public String defaultValue;
        public final Class<?> type;
        public boolean _transient;
        public boolean _final;

        private Option(String key, String label, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
            this.key = key;
            this.label = label;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this._final = _final;
            this._transient = _transient;
        }

        public boolean isFinal() {
            return this._final;
        }

        public void setFinal(boolean _final) {
            this._final = _final;
        }

        public boolean isTransient() {
            return this._transient;
        }

        public void setTransient(boolean _transient) {
            this._transient = _transient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return I18n._((String)this.description, (Object[])new Object[0]);
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        public static enum ComportmentEditingCellEnum {
            ALL,
            NOTHING;

        }
    }
}

