/*
 * #%L
 * Lima Swing
 * 
 * $Id: AccountTableCellEditor.java 3680 2013-06-12 16:03:34Z Bavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/celleditor/AccountTableCellEditor.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.celleditor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.combobox.LeafAccountComboBoxModel;
import org.chorem.lima.ui.common.AccountListRenderer;
import org.chorem.lima.util.AccountToString;
import org.chorem.lima.widgets.JWideComboBox;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;

/**
 * Editor des cellules de tableau de type "Account".
 * Affiche une wide combo box pour selectionner un compte.
 * 
 * @author chatellier
 * @version $Revision: 3680 $
 * 
 * Last update : $Date: 2013-06-12 18:03:34 +0200 (Wed, 12 Jun 2013) $
 * By : $Author: Bavencoff $
 */
public class AccountTableCellEditor extends AbstractCellEditor implements TableCellEditor, KeyListener {

    protected static final Log log = LogFactory.getLog(AccountTableCellEditor.class);

    private final JWideComboBox comboBox;

    private static final long serialVersionUID = 1L;

    private static boolean keyPressed;

    /** constructor */
    public AccountTableCellEditor() {
        comboBox = new JWideComboBox();
        LeafAccountComboBoxModel accountComboBoxModel = new LeafAccountComboBoxModel();
        comboBox.setModel(accountComboBoxModel);
        AccountListRenderer accountRenderer = new AccountListRenderer();
        comboBox.setRenderer(accountRenderer);
        AutoCompleteDecorator.decorate(comboBox, AccountToString.getInstance());
        comboBox.getEditor().getEditorComponent().addKeyListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Account) {
            comboBox.setSelectedItem(value);
        }
        return comboBox;
    }

    @Override
    public Object getCellEditorValue() {
        return comboBox.getSelectedItem();
    }

    /**
     * Vérifie si la cellule peut être éditable :
     * seulement si il y a une frappe au clavier ou un double clic.
     *
     * @param evt
     * @return
     */
    @Override
    public boolean isCellEditable(EventObject evt) {
        // Si il y a une frappe au clavier
        if (evt instanceof KeyEvent) {
            final KeyEvent keyEvent = (KeyEvent) evt;
            // Empèche la touche echap
            if (keyEvent.getKeyChar() != KeyEvent.VK_ESCAPE) {
                // Permet de placer le focus sur l'editor de la comboBox
                SwingUtilities.invokeLater(new Runnable() {
                    @Override
                    public void run() {
                        comboBox.getEditor().getEditorComponent().requestFocus();
                        JTextComponent edit = (JTextComponent) comboBox.getEditor().getEditorComponent();
                        if (!Character.isIdentifierIgnorable(keyEvent.getKeyChar())) {
                            edit.setText(Character.toString(keyEvent.getKeyChar()));
                        }
                    }
                });
            }
        }
        keyPressed = false;
        return !(evt instanceof MouseEvent) || ((MouseEvent) evt).getClickCount() == 1;
    }


    @Override
    public void keyPressed(KeyEvent e) {

    }

    @Override
    public void keyReleased(KeyEvent e) {

        // Vérifie si c'est la première frappe au clavier
        if (!keyPressed) {
            // Récupère l'editor de la comboBox
            JTextComponent edit = (JTextComponent) comboBox.getEditor().getEditorComponent();
            // Met en place le curseur et la selection après la première lettre
            edit.select(1, edit.getText().length());
            keyPressed = true;
        }

        // delegate popup list menu
        if (e.getKeyChar() == KeyEvent.VK_ENTER) {
            fireEditingStopped();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {

    }

}
