/*
 * #%L
 * Lima Swing
 * 
 * $Id: ComboBoxPeriodEnum.java 3293 2011-09-17 14:17:04Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/enums/ComboBoxPeriodEnum.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.enums;

import static org.nuiton.i18n.I18n._;


public enum ComboBoxPeriodEnum {

    PERIOD(_("lima.enum.comboboxperiod.period")),
    DATE(_("lima.enum.comboboxperiod.date")),
    FISCAL_PERIOD(_("lima.enum.comboboxperiod.fiscalperiod")),
    FINANCIAL_PERIOD(_("lima.enum.comboboxperiod.financialperiod"));

    private final String description;

    ComboBoxPeriodEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public static String[] descriptions() {
        int nbElts = ComboBoxPeriodEnum.values().length;
        String[] descriptions = new String[nbElts];
        ComboBoxPeriodEnum[] enums = ComboBoxPeriodEnum.values();
        for (int i = 0; i < nbElts; i++) {
            descriptions[i] = enums[i].getDescription();
        }
        return descriptions;
    }

    public static ComboBoxPeriodEnum valueOfDescription(String description) {
        ComboBoxPeriodEnum value = null;

        for (ComboBoxPeriodEnum enums : ComboBoxPeriodEnum.values()) {
            if (description.equals(enums.description)) {
                value = enums;
                break;
            }
        }
        return value;
    }
}
