/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.vatchart;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaBusinessException;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.api.VatStatementService;
import org.chorem.lima.entity.VatStatement;
import org.chorem.lima.entity.VatStatementImpl;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.enums.VatStatementsChartEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.ui.vatchart.VatChartImportForm;
import org.chorem.lima.ui.vatchart.VatChartMovementForm;
import org.chorem.lima.ui.vatchart.VatChartTreeTable;
import org.chorem.lima.ui.vatchart.VatChartTreeTableModel;
import org.chorem.lima.ui.vatchart.VatChartView;
import org.nuiton.i18n.I18n;

public class VatChartViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(VatChartViewHandler.class);
    protected VatStatementService vatStatementService;
    protected VatChartView view;

    protected VatChartViewHandler(VatChartView view) {
        this.view = view;
        this.vatStatementService = (VatStatementService)LimaServiceFactory.getService(VatStatementService.class);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
    }

    public void addVatStatementMovement() {
        VatChartTreeTableModel treeTableModel = (VatChartTreeTableModel)this.view.getTreeTable().getTreeTableModel();
        int selectedRow = this.view.getTreeTable().getSelectedRow();
        TreePath treePath = selectedRow == -1 ? null : this.view.getTreeTable().getPathForRow(selectedRow);
        VatStatementImpl newVatChartMovement = new VatStatementImpl();
        VatChartMovementForm vatChartMovementForm = new VatChartMovementForm((JAXXContext)this.view);
        VatStatement masterVatStatement = null;
        if (selectedRow != -1) {
            masterVatStatement = (VatStatement)treePath.getLastPathComponent();
        }
        newVatChartMovement.setMasterVatStatement(masterVatStatement);
        vatChartMovementForm.setVatStatement((VatStatement)newVatChartMovement);
        vatChartMovementForm.setLocationRelativeTo((Component)((Object)this.view));
        vatChartMovementForm.setVisible(true);
        newVatChartMovement = vatChartMovementForm.getVatStatement();
        if (newVatChartMovement != null) {
            try {
                treeTableModel.addVatStatement(treePath, (VatStatement)newVatChartMovement);
            }
            catch (LimaBusinessException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add Vat chart Movement", (Throwable)eee);
                }
                JOptionPane.showMessageDialog((Component)((Object)this.view), eee.getMessage(), I18n._((String)"lima.common.error", (Object[])new Object[0]), 0);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add Vat chart Movement", (Throwable)eee);
                }
                JOptionPane.showMessageDialog((Component)((Object)this.view), eee.getMessage(), I18n._((String)"lima.common.error", (Object[])new Object[0]), 0);
            }
            this.refresh();
        }
    }

    public void updateVatStatement() {
        VatChartTreeTable treeTable = this.view.getTreeTable();
        VatChartTreeTableModel treeTableModel = (VatChartTreeTableModel)treeTable.getTreeTableModel();
        int selectedRow = this.view.treeTable.getSelectedRow();
        TreePath treePath = this.view.treeTable.getPathForRow(selectedRow);
        VatStatement vatStatement = (VatStatement)treePath.getLastPathComponent();
        if (vatStatement != null) {
            treePath = selectedRow != -1 ? this.view.treeTable.getPathForRow(selectedRow) : new TreePath(treeTableModel.getRoot());
            VatChartMovementForm vatChartMovementForm = new VatChartMovementForm((JAXXContext)this.view);
            if (vatStatement.getMasterVatStatement() == null) {
                VatStatementImpl masterVatStatement = new VatStatementImpl();
                vatStatement.setMasterVatStatement((VatStatement)masterVatStatement);
            }
            vatChartMovementForm.setVatStatement(vatStatement);
            vatChartMovementForm.setLocationRelativeTo((Component)((Object)this.view));
            vatChartMovementForm.setVisible(true);
            vatStatement = vatChartMovementForm.getVatStatement();
            if (vatStatement != null) {
                try {
                    treeTableModel.updateVatStatement(treePath, vatStatement);
                }
                catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't add update", (Throwable)eee);
                    }
                    JOptionPane.showMessageDialog((Component)((Object)this.view), eee.getMessage(), I18n._((String)"lima.common.error", (Object[])new Object[0]), 0);
                }
            }
        }
        this.refresh();
    }

    public void importVatStatementChart() {
        VatChartImportForm form = new VatChartImportForm();
        form.setLocationRelativeTo((Component)((Object)this.view));
        form.setVisible(true);
        Object value = form.getRadioButtons().getSelectedValue();
        if (value != null) {
            block4: {
                if (form.getDeleteVatStatementChart().isSelected()) {
                    try {
                        this.vatStatementService.removeAllVatStatement();
                    }
                    catch (LimaException eee) {
                        if (!log.isDebugEnabled()) break block4;
                        log.debug((Object)"Can't delete financial statement chart", (Throwable)eee);
                    }
                }
            }
            VatStatementsChartEnum defaultVatStatementsEnum = (VatStatementsChartEnum)((Object)value);
            ImportExport importExport = new ImportExport((Component)((Object)this.view));
            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT, defaultVatStatementsEnum.getFilePath(), true);
            this.refresh();
        }
    }

    public void removeVatStatement() {
        VatChartTreeTable treeTable = this.view.getTreeTable();
        VatChartTreeTableModel treeTableModel = (VatChartTreeTableModel)treeTable.getTreeTableModel();
        int selectedRow = this.view.treeTable.getSelectedRow();
        if (selectedRow != -1) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.charts.vatstatement.question.remove", (Object[])new Object[0]), I18n._((String)"lima.common.confirmation", (Object[])new Object[0]), 0, 3);
            if (n == 0) {
                TreePath treePath = treeTable.getPathForRow(selectedRow);
                VatStatement vatStatement = (VatStatement)treePath.getLastPathComponent();
                if (!treeTableModel.isLeaf(vatStatement)) {
                    JOptionPane.showMessageDialog((Component)((Object)this.view), I18n._((String)"lima.charts.vatstatement.deleteparent", (Object[])new Object[0]), I18n._((String)"lima.common.info", (Object[])new Object[0]), 1);
                } else {
                    try {
                        treeTableModel.removeVatStatementObject(treePath, vatStatement);
                    }
                    catch (LimaException eee) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can't delete account", (Throwable)eee);
                        }
                        JOptionPane.showMessageDialog((Component)((Object)this.view), eee.getMessage(), I18n._((String)"lima.common.error", (Object[])new Object[0]), 0);
                    }
                }
            }
            this.refresh();
        }
    }

    public void refresh() {
        block2: {
            VatChartTreeTable treeTable = this.view.getTreeTable();
            VatChartTreeTableModel treeTableModel = (VatChartTreeTableModel)treeTable.getTreeTableModel();
            try {
                treeTableModel.refreshTree();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't refresh model", (Throwable)eee);
            }
        }
        this.view.repaint();
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("VatStatements") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.refresh();
        }
    }
}

