/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.lettering;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.LetteringFilter;
import org.chorem.lima.beans.LetteringFilterImpl;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.lettering.LetteringEditModel;
import org.chorem.lima.ui.lettering.LetteringTable;
import org.chorem.lima.ui.lettering.LetteringTableModel;
import org.chorem.lima.ui.lettering.LetteringView;
import org.chorem.lima.ui.lettering.LettringSelectionModel;

public class LetteringViewHandler {
    protected LetteringView view;
    protected LetteringTable table;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;
    protected AccountService accountService;
    protected FinancialTransactionService financialTransactionService;
    protected EntryBookService entryBookService;
    protected LetteringFilterImpl filter;
    protected BigDecimal debit = BigDecimal.ZERO;
    protected BigDecimal credit = BigDecimal.ZERO;
    protected BigDecimal solde = BigDecimal.ZERO;
    protected LettringSelectionModel lettringSelectionModel;
    protected LetteringEditModel editModel;
    private static final Log log = LogFactory.getLog(LetteringViewHandler.class);

    public LetteringViewHandler(LetteringView view) {
        this.view = view;
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
        this.entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);
    }

    public void init() {
        this.filter = this.view.getFilterModel();
        this.editModel = this.view.getEditModel();
        this.lettringSelectionModel = this.view.getLettringSelectionModel();
        this.loadComboAndRows();
        this.filter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LetteringViewHandler.this.updateAllEntries();
            }
        });
    }

    public void balanceAndActions() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"balanceAndActions");
        }
        if (this.view.getTable().getSelectedRows().length == 0) {
            this.onButtonModeChanged(buttonMode.ALL);
            this.onBalanceChanged(null);
        } else if (!this.letteringNotExist(this.view.getTable().getSelectedRow())) {
            this.onBalanceChanged(null);
            this.setValuesForSelectedEntries();
            this.onButtonModeChanged(buttonMode.DELETTRED);
        } else {
            int[] selectedRows;
            if (log.isDebugEnabled()) {
                log.debug((Object)"unlettred entries");
            }
            if ((selectedRows = this.view.getTable().getSelectedRows()).length == 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"2 rows selected");
                }
                LetteringTableModel tableModel = this.view.getTableModel();
                Entry firstSelectedEntry = tableModel.getEntryAt(selectedRows[0]);
                Entry secondSelectedEntry = tableModel.getEntryAt(selectedRows[1]);
                BigDecimal firstSelectedEntryAmount = firstSelectedEntry.getAmount();
                BigDecimal secondSelectedEntryAmount = secondSelectedEntry.getAmount();
                if (secondSelectedEntry.getDebit() != firstSelectedEntry.getDebit() && firstSelectedEntryAmount.subtract(secondSelectedEntryAmount).abs().compareTo(BigDecimal.ZERO) > 0 && firstSelectedEntryAmount.subtract(secondSelectedEntryAmount).abs().compareTo(BigDecimal.ONE) < 0) {
                    this.onButtonModeChanged(buttonMode.EQUALIZED);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"!2 rows selected");
                }
                this.onButtonModeChanged(buttonMode.ALL);
            }
            this.onBalanceChanged(null);
            if (!this.view.getLettringSelectionModel().isSelectionEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Rows selected");
                }
                this.setValuesForSelectedEntries();
                this.onButtonModeChanged(buttonMode.LETTRED);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No Rows selected");
                }
                this.onButtonModeChanged(buttonMode.ALL);
            }
        }
    }

    public boolean letteringNotExist(int row) {
        boolean emptyOrNull = false;
        if (row != -1) {
            Entry entry = this.view.getTableModel().getEntryAt(row);
            String lettering = entry.getLettering();
            emptyOrNull = lettering == null || lettering.isEmpty();
        }
        return emptyOrNull;
    }

    public void onButtonModeChanged(buttonMode buttonMode2) {
        switch (buttonMode2) {
            case DELETTRED: {
                this.editModel.setLettred(false);
                this.editModel.setUnLettred(true);
                break;
            }
            case LETTRED: {
                this.editModel.setUnLettred(false);
                this.editModel.setLettred(true);
                break;
            }
            case EQUALIZED: {
                this.editModel.setEqualized(true);
                break;
            }
            default: {
                this.editModel.setLettred(false);
                this.editModel.setUnLettred(false);
                this.editModel.setEqualized(false);
            }
        }
    }

    public void setValuesForSelectedEntries() {
        LetteringTableModel tableModel = this.view.getTableModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!this.view.getLettringSelectionModel().isSelectedIndex(i)) continue;
            Entry selectedEntry = tableModel.getEntryAt(i);
            this.onBalanceChanged(selectedEntry);
        }
    }

    public void onBalanceChanged(Entry balance) {
        if (balance == null) {
            this.editModel.setCredit(BigDecimal.ZERO);
            this.editModel.setDebit(BigDecimal.ZERO);
            this.editModel.setSolde(BigDecimal.ZERO, false);
        } else {
            this.balanceCalculation(balance.getAmount(), balance.getDebit());
        }
    }

    public void balanceCalculation(BigDecimal amount, boolean debit) {
        BigDecimal creditVal;
        BigDecimal debitVal = debit ? amount : BigDecimal.ZERO;
        BigDecimal bigDecimal = creditVal = debit ? BigDecimal.ZERO : amount;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Balance calculation");
        }
        if (debitVal.equals(BigDecimal.ZERO)) {
            if (!creditVal.equals(BigDecimal.ZERO)) {
                this.editModel.setCredit(creditVal);
                this.editModel.setSolde(creditVal, true);
            }
        } else if (creditVal.equals(BigDecimal.ZERO)) {
            this.editModel.setDebit(debitVal);
            this.editModel.setSolde(debitVal, false);
        } else {
            this.onBalanceChanged(null);
        }
    }

    public void loadComboAndRows() {
        List allAccounts = this.accountService.getAllAccounts();
        this.view.getAccountComboBoxModel().setObjects(allAccounts);
        if (!allAccounts.isEmpty()) {
            this.view.getAccountComboBox().setSelectedItem(allAccounts.get(0));
        }
        FiscalPeriod fiscalPeriod = this.fiscalPeriodService.getLastFiscalPeriod();
        Calendar calendar = Calendar.getInstance();
        int dernierJourMoisCourant = calendar.getActualMaximum(5);
        int premierJourMoisCourant = calendar.getActualMinimum(5);
        Date defaultDateBegFiscalPeriod = fiscalPeriod != null ? this.fiscalPeriodService.getLastFiscalPeriod().getBeginDate() : DateUtils.setDays((Date)new Date(), (int)premierJourMoisCourant);
        Date defaultDateEndCurrent = DateUtils.setDays((Date)new Date(), (int)dernierJourMoisCourant);
        this.view.getPickerDebut().setDate(defaultDateBegFiscalPeriod);
        this.view.getPickerFin().setDate(defaultDateEndCurrent);
        this.filter.setDateStart(defaultDateBegFiscalPeriod);
        this.filter.setDateEnd(defaultDateEndCurrent);
        this.filter.setDisplayUnlettred(true);
        this.updateAllEntries();
    }

    protected List<Entry> findAllEntries(LetteringFilterImpl filter) {
        if (filter != null) {
            List entries = this.financialTransactionService.getAllEntrieByDatesAndAccountAndLettering((LetteringFilter)filter);
            return entries;
        }
        return null;
    }

    public void updateAllEntries() {
        if (this.isFilterValid()) {
            List<Entry> entries = this.findAllEntries(this.filter);
            ArrayList<String> journalEntrees = new ArrayList<String>();
            ArrayList<Date> datesEntree = new ArrayList<Date>();
            for (Entry entry : entries) {
                FinancialTransaction financialTransaction = entry.getFinancialTransaction();
                datesEntree.add(financialTransaction.getTransactionDate());
                if (financialTransaction.getEntryBook() == null || financialTransaction.getEntryBook().getLabel() == null) {
                    journalEntrees.add("");
                    continue;
                }
                journalEntrees.add(financialTransaction.getEntryBook().getLabel());
            }
            this.view.getTableModel().updateEntries(entries, datesEntree, journalEntrees);
        }
        this.onBalanceChanged(null);
    }

    public void roundAndCreateEntry() {
        LetteringTableModel tableModel = this.view.getTableModel();
        int[] selectedRows = this.view.getTable().getSelectedRows();
        if (selectedRows.length == 2) {
            Entry firstSelectedEntry = tableModel.getEntryAt(selectedRows[0]);
            Entry secondSelectedEntry = tableModel.getEntryAt(selectedRows[1]);
            Entry[] newEntriesFormEqualizing = this.financialTransactionService.getEntriesFromEqualizing(firstSelectedEntry, secondSelectedEntry);
            Entry newSameAccountEntry = newEntriesFormEqualizing[0];
            Entry newCostOrProductEntry = newEntriesFormEqualizing[1];
            tableModel.addEntry(newSameAccountEntry, newSameAccountEntry.getFinancialTransaction().getTransactionDate());
            tableModel.addEntry(newCostOrProductEntry, newCostOrProductEntry.getFinancialTransaction().getTransactionDate());
            this.view.getLettringSelectionModel().selectRoundedAndNewEntries(selectedRows[0], selectedRows[1], newSameAccountEntry);
        }
    }

    protected boolean isFilterValid() {
        boolean valid = false;
        if (this.filter.getAccount() != null && this.filter.getDateStart() != null && this.filter.getDateEnd() != null) {
            valid = true;
        }
        return valid;
    }

    public void back(JComboBox comboBox) {
        int row = comboBox.getSelectedIndex();
        if (row > 0) {
            comboBox.setSelectedIndex(row - 1);
        }
        this.view.getLettringSelectionModel().clearSelection();
    }

    public void next(JComboBox comboBox) {
        int size = comboBox.getModel().getSize();
        int row = comboBox.getSelectedIndex();
        if (row < size - 1) {
            comboBox.setSelectedIndex(row + 1);
        }
        this.view.getLettringSelectionModel().clearSelection();
    }

    public void addLetter() {
        String newLetters = this.financialTransactionService.getNextLetters();
        this.changeLetter(newLetters);
        this.onButtonModeChanged(buttonMode.DELETTRED);
    }

    public void removeLetter() {
        this.changeLetter(null);
        this.onButtonModeChanged(buttonMode.LETTRED);
    }

    protected void changeLetter(String newLetters) {
        int[] entrieSelected = this.view.getTable().getSelectedRows();
        this.view.getTableModel().updateLettersSelectedEntries(entrieSelected, newLetters);
        for (int indexEntry : entrieSelected) {
            this.financialTransactionService.updateEntry(this.view.getTableModel().getEntryAt(indexEntry));
        }
    }

    protected static enum buttonMode {
        DELETTRED,
        LETTRED,
        EQUALIZED,
        ALL;

    }
}

