/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionunbalanced;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedTable;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedTableModel;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedView;
import org.nuiton.i18n.I18n;

public class FinancialTransactionUnbalancedViewHandler {
    private static final Log log = LogFactory.getLog(FinancialTransactionUnbalancedViewHandler.class);
    protected FinancialTransactionUnbalancedView view;

    protected FinancialTransactionUnbalancedViewHandler(FinancialTransactionUnbalancedView view) {
        this.view = view;
    }

    public void addEmptyEntry() {
        FinancialTransactionUnbalancedTable table = this.view.getFinancialTransactionUnbalancedTable();
        FinancialTransactionUnbalancedTableModel tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
            String description = (String)tableModel.getValueAt(indexSelectedRow, 4);
            int index = tableModel.addEmptyEntry(selectedValue, description, indexSelectedRow);
            ListSelectionModel selectionModel = table.getSelectionModel();
            selectionModel.setSelectionInterval(indexSelectedRow + 1, indexSelectedRow + 1);
            table.changeSelection(index, 1, false, false);
            table.requestFocusInWindow();
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call addentry selected transaction without selection");
        }
    }

    public void deleteSelectedRow() {
        FinancialTransactionUnbalancedTable table = this.view.getFinancialTransactionUnbalancedTable();
        FinancialTransactionUnbalancedTableModel tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
            String message = selectedValue instanceof FinancialTransaction ? I18n._((String)"lima.charts.financialtransaction.question.removetransaction", (Object[])new Object[0]) : I18n._((String)"lima.charts.financialtransaction.question.removeentry", (Object[])new Object[0]);
            int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), message, I18n._((String)"lima.common.confirmation", (Object[])new Object[0]), 0);
            if (response == 0) {
                tableModel.removeObject(selectedValue, indexSelectedRow);
                ListSelectionModel selectionModel = table.getSelectionModel();
                selectionModel.setSelectionInterval(indexSelectedRow - 1, indexSelectedRow - 1);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call delete selected row without selection");
        }
    }

    public void refresh() {
        FinancialTransactionUnbalancedTableModel tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        tableModel.refresh();
        FiscalPeriodComboBoxModel comboBoxModel = this.view.getModelFiscalPeriod();
        comboBoxModel.refresh();
    }
}

