/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.combobox.AccountComboBoxModel;
import org.chorem.lima.ui.common.AccountListRenderer;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;
import org.chorem.lima.util.AccountToString;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class AccountSearchComboBox
extends JComboBox
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AccountSearchComboBox.class);
    protected FinancialTransactionSearchViewHandler handler;

    public AccountSearchComboBox(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
        AccountComboBoxModel accountComboBoxModel = new AccountComboBoxModel();
        AccountListRenderer accountRenderer = new AccountListRenderer();
        this.setModel(accountComboBoxModel);
        this.setRenderer(accountRenderer);
        this.setEditable(true);
        AutoCompleteDecorator.decorate((JComboBox)this, (ObjectToStringConverter)AccountToString.getInstance());
        this.getEditor().getEditorComponent().addKeyListener(this);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = this.getSelectedItem();
        if (object instanceof Account) {
            this.handler.setAccount((Account)this.getSelectedItem());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Account account;
        Object object = this.getSelectedItem();
        if (object instanceof Account && !(account = (Account)this.getSelectedItem()).equals(this.handler.getAccount())) {
            this.handler.setAccount(account);
        }
        if (e.getKeyChar() == '\n') {
            this.firePopupMenuCanceled();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

