/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialperiod;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;
import org.chorem.lima.ui.financialperiod.FinancialPeriodViewHandler;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class FinancialPeriodTable
extends JXTable
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = -1960326844433064178L;
    protected FinancialPeriodViewHandler handler;
    protected FinancialPeriodTableModel model;

    public FinancialPeriodTable(FinancialPeriodViewHandler handler) {
        this.handler = handler;
        this.model = handler.view.getFinancialPeriodTableModel();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addStripingColor();
        this.addBlockColor();
    }

    protected void addStripingColor() {
        Highlighter colorTransaction = HighlighterFactory.createSimpleStriping((Color)new Color(233, 233, 233));
        this.addHighlighter(colorTransaction);
    }

    protected void addBlockColor() {
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                ClosedPeriodicEntryBook closedPeriodicEntryBook = FinancialPeriodTable.this.model.getElementAt(adapter.row);
                return closedPeriodicEntryBook.getLocked();
            }
        };
        ColorHighlighter colorTransaction = new ColorHighlighter(predicate, null, new Color(222, 0, 0));
        this.addHighlighter((Highlighter)colorTransaction);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.rowAtPoint(e.getPoint()) == -1) {
            this.clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && !this.isEditing()) {
            this.clearSelection();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

