/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybooksreports;

import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.business.DocumentServiceMonitorable;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ReportServiceMonitorable;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.entrybooksreports.EntryBooksReportsTable;
import org.chorem.lima.ui.entrybooksreports.EntryBooksReportsTableModel;
import org.chorem.lima.ui.entrybooksreports.EntryBooksReportsView;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class EntryBooksReportsViewHandler
implements ServiceListener {
    protected EntryBooksReportsView view;
    protected EntryBooksReportsTable table;
    protected EntryBooksReportsTableModel tableModel;
    private static final Log log = LogFactory.getLog(EntryBooksReportsViewHandler.class);
    protected ReportServiceMonitorable reportService;
    protected DocumentServiceMonitorable documentService;
    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    protected EntryBook selectedEntryBook;
    protected Date selectedBeginDate;
    protected Date selectedEndDate;
    protected int port;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    protected EntryBooksReportsViewHandler(EntryBooksReportsView view) {
        this.view = view;
        this.reportService = LimaServiceFactory.getInstance().getService(ReportServiceMonitorable.class);
        this.port = LimaServiceFactory.getInstance().getService(HttpServerServiceMonitorable.class).getHttpPort();
        this.documentService = LimaServiceFactory.getInstance().getService(DocumentServiceMonitorable.class);
        this.fiscalPeriodService = LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class).addListener((ServiceListener)this);
    }

    public void setBeginDate(Date date) {
        this.selectedBeginDate = date;
        this.refresh();
    }

    public void setEndDate(Date date) {
        this.selectedEndDate = date;
        this.refresh();
    }

    public void setEntryBook(EntryBook entryBook) {
        this.selectedEntryBook = entryBook;
        this.refresh();
    }

    public ReportsDatas getDataList() {
        ReportsDatas results = null;
        if (this.selectedEntryBook != null) {
            try {
                results = this.reportService.generateEntryBooksReports(this.selectedEntryBook, this.selectedBeginDate, this.selectedEndDate);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Can't update model", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"lima.entrybooksreports.listerror", (Object[])new Object[0]), eee);
            }
        }
        return results;
    }

    public void refresh() {
        if (this.selectedBeginDate != null && this.selectedEndDate != null && this.selectedEntryBook != null) {
            this.tableModel = this.view.getModelTable();
            ReportsDatas datasList = this.getDataList();
            this.tableModel.refresh(datasList);
            if (datasList != null) {
                this.view.amountCreditLabel.setText(String.valueOf(datasList.getAmountCredit()));
                this.view.amountDebitLabel.setText(String.valueOf(datasList.getAmountDebit()));
                BigDecimal amountSolde = datasList.getAmountSolde();
                this.view.amountSoldeLabel.setText(String.valueOf(amountSolde));
                if (amountSolde == BigDecimal.ZERO) {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.solde", (Object[])new Object[0]));
                } else if (datasList.getSoldeDebit()) {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.soldedebit", (Object[])new Object[0]));
                } else {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.soldecredit", (Object[])new Object[0]));
                }
            }
        }
    }

    public void createDocument() {
        if (this.selectedBeginDate != null && this.selectedEndDate != null) {
            List blockedFiscalPeriods = new ArrayList();
            try {
                blockedFiscalPeriods = this.fiscalPeriodService.getAllBlockedFiscalPeriods();
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Enable to create document ", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"lima.entrybooksreports.documentcreationerror", (Object[])new Object[0]), eee);
            }
            boolean error = true;
            for (FiscalPeriod blockedFiscalPeriod : blockedFiscalPeriods) {
                if (!blockedFiscalPeriod.getBeginDate().equals(this.selectedBeginDate) || !blockedFiscalPeriod.getEndDate().equals(this.selectedEndDate) || !blockedFiscalPeriod.getLocked()) continue;
                error = false;
            }
            if (error) {
                JOptionPane.showMessageDialog((Component)((Object)this.view), I18n._((String)"lima.entrybooksreports.documentcreationfiscalerror", (Object[])new Object[0]), I18n._((String)"lima.common.error", (Object[])new Object[0]), 0);
            } else {
                FormatsEnum selectedEnum = (FormatsEnum)this.view.getDocumentEditor().getSelectedItem();
                String address = LimaConfig.getInstance().getHostAdress();
                try {
                    String url = "http://" + address + ":" + this.port + "/?beginDate=" + dateFormat.format(this.selectedBeginDate) + "&endDate=" + dateFormat.format(this.selectedEndDate) + "&format=" + selectedEnum.getExtension() + "&model=" + DocumentsEnum.ENTRYBOOKS.getFileName();
                    Desktop.getDesktop().browse(new URI(url));
                    String url2 = "http://" + address + ":" + this.port + "/?beginDate=" + dateFormat.format(this.selectedBeginDate) + "&endDate=" + dateFormat.format(this.selectedEndDate) + "&format=" + selectedEnum.getExtension() + "&model=" + DocumentsEnum.GENERAL_ENTRYBOOK.getFileName();
                    Desktop.getDesktop().browse(new URI(url2));
                }
                catch (IOException e) {
                    log.error((Object)"Can't open browser", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    log.error((Object)"Can't create news URI", (Throwable)e);
                }
            }
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("importEntryBook") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

