/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybook;

import java.awt.Component;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.EntryBookServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ejbinterface.EntryBookService;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryBookImpl;
import org.chorem.lima.enums.EntryBooksChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.entrybook.EntryBookForm;
import org.chorem.lima.ui.entrybook.EntryBookImportForm;
import org.chorem.lima.ui.entrybook.EntryBookTable;
import org.chorem.lima.ui.entrybook.EntryBookTableModel;
import org.chorem.lima.ui.entrybook.EntryBookView;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.util.DialogHelper;
import org.nuiton.i18n.I18n;

public class EntryBookViewHandler {
    private static final Log log = LogFactory.getLog(EntryBookViewHandler.class);
    protected EntryBookView view;
    protected EntryBookService entryBookService;

    public EntryBookViewHandler(EntryBookView view) {
        this.view = view;
        this.entryBookService = (EntryBookService)LimaServiceFactory.getInstance().getService(EntryBookServiceMonitorable.class);
    }

    public void addEntryBook() {
        EntryBookTable entryBookTable = this.view.getEntryBooksTable();
        EntryBookTableModel entryBookTableModel = (EntryBookTableModel)entryBookTable.getModel();
        EntryBookImpl newEntryBook = new EntryBookImpl();
        EntryBookForm entryBookForm = new EntryBookForm((JAXXContext)this.view);
        entryBookForm.setEntryBook((EntryBook)newEntryBook);
        entryBookForm.setLocationRelativeTo((Component)((Object)this.view));
        entryBookForm.setVisible(true);
        newEntryBook = entryBookForm.getEntryBook();
        if (newEntryBook != null) {
            try {
                entryBookTableModel.addEntryBook((EntryBook)newEntryBook);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add entry book", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        }
    }

    public void updateEntryBook() {
        EntryBookTable entryBookTable = this.view.getEntryBooksTable();
        int selectedRow = entryBookTable.getSelectedRow();
        EntryBookTableModel entryBookTableModel = (EntryBookTableModel)entryBookTable.getModel();
        try {
            EntryBook selectedEntryBook = entryBookTableModel.getEntryBookAtRow(selectedRow);
            EntryBookForm entryBookForm = new EntryBookForm((JAXXContext)this.view);
            entryBookForm.setEntryBook(selectedEntryBook);
            entryBookForm.setLocationRelativeTo((Component)((Object)this.view));
            entryBookForm.setVisible(true);
            selectedEntryBook = entryBookForm.getEntryBook();
            if (selectedEntryBook != null) {
                entryBookTableModel.updateEntryBook(selectedEntryBook);
            }
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add update book", (Throwable)eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }

    public void deleteEntryBook() {
        EntryBookTable entryBookTable = this.view.getEntryBooksTable();
        int selectedRow = entryBookTable.getSelectedRow();
        EntryBookTableModel entryBookTableModel = (EntryBookTableModel)entryBookTable.getModel();
        try {
            EntryBook selectedEntryBook = entryBookTableModel.getEntryBookAtRow(selectedRow);
            int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.charts.entrybook.confirmation", (Object[])new Object[]{selectedEntryBook.getLabel()}), I18n._((String)"lima.common.confirmation", (Object[])new Object[0]), 0, 3);
            if (response == 0) {
                entryBookTableModel.removeEntryBook(selectedEntryBook);
            }
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't delete update book", (Throwable)eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }

    public void importEntryBooks() {
        EntryBookImportForm form = new EntryBookImportForm();
        form.setLocationRelativeTo((Component)((Object)this.view));
        form.setVisible(true);
        Object value = form.getRadioButtons().getSelectedValue();
        if (value != null) {
            EntryBooksChartEnum defaultEntryBooksEnum = (EntryBooksChartEnum)((Object)value);
            ImportExport importExport = ImportExport.getInstance((Component)((Object)this.view));
            importExport.importExport(ImportExportEnum.CSV_ENTRYBOOKS_IMPORT, defaultEntryBooksEnum.getFilePath(), true);
        }
    }
}

