/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.accountsreports;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ReportServiceMonitorable;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Account;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.accountsreports.AccountsReportsTable;
import org.chorem.lima.ui.accountsreports.AccountsReportsTableModel;
import org.chorem.lima.ui.accountsreports.AccountsReportsView;
import org.chorem.lima.ui.combobox.AccountComboBoxModel;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class AccountsReportsViewHandler
implements ServiceListener {
    protected AccountsReportsView view;
    protected AccountsReportsTable table;
    protected AccountsReportsTableModel tableModel;
    protected AccountComboBoxModel comboBoxModel;
    private static final Log log = LogFactory.getLog(AccountsReportsViewHandler.class);
    protected Account selectedAccount;
    protected Date selectedBeginDate;
    protected Date selectedEndDate;
    protected ReportServiceMonitorable reportService;

    protected AccountsReportsViewHandler(AccountsReportsView view) {
        this.view = view;
        this.reportService = LimaServiceFactory.getInstance().getService(ReportServiceMonitorable.class);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class).addListener((ServiceListener)this);
    }

    public void setBeginDate(Date date) {
        this.selectedBeginDate = date;
        this.refresh();
    }

    public void setEndDate(Date date) {
        this.selectedEndDate = date;
        this.refresh();
    }

    public void setAccount(Account account) {
        this.selectedAccount = account;
        this.refresh();
    }

    public ReportsDatas getDataList() {
        ReportsDatas results = null;
        if (this.selectedAccount != null) {
            try {
                results = this.reportService.generateAccountsReports(this.selectedAccount, Boolean.valueOf(true), this.selectedBeginDate, this.selectedEndDate);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Can't update model", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"lima.accountsreports.listerror", (Object[])new Object[0]), eee);
            }
        }
        return results;
    }

    public void refresh() {
        if (this.selectedBeginDate != null && this.selectedEndDate != null && this.selectedAccount != null) {
            ReportsDatas datasList = this.getDataList();
            this.tableModel = this.view.getModelAccountsReportsTable();
            this.tableModel.refresh(datasList);
            if (datasList != null) {
                this.view.amountCreditLabel.setText(datasList.getAmountCredit().toString());
                this.view.amountDebitLabel.setText(datasList.getAmountDebit().toString());
                BigDecimal amountSolde = datasList.getAmountSolde();
                this.view.amountSoldeLabel.setText(amountSolde.toString());
                if (amountSolde == BigDecimal.ZERO) {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.solde", (Object[])new Object[0]));
                } else if (datasList.getSoldeDebit()) {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.soldedebit", (Object[])new Object[0]));
                } else {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.soldecredit", (Object[])new Object[0]));
                }
            }
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("importAccount") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

