/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.entrybooksreports;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.EnumEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import org.chorem.lima.ui.combobox.EntryBookComboBoxModel;
import static org.nuiton.i18n.I18n._;

public class EntryBooksReportsView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PERIOD_COMBO_BOX = "periodComboBox";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTXPTRhjeuDiJ46YFUsJHoU2ppnBo5YQphzZMmg8SkowpEPcj4AsraydeutKquysseujwE/gJ7Z0LM71xYjhw7qEXhr/Q6XDoleHdlSVZtkIytg+S/H48+7xf+z7+F5WlQJ/dw1Fki9BX1CP29sru7g3nHmmpq0S2BA0UFyj+jZVQqYmqbiqXCn3erGv3Wte9tsa9gPvE7/FerKMpqR4wItuEKIXO5T1aUtYaqXoxCkKRoKakilD/eP1f6ZH78M8SQlEA7M5AKHMHeWWRHKmjEnUVOg4n3cc1hv09oCGovwd8p7VsjWEpv8ce+RX9jibqaDzAAsAUOn/4kA2G8Y8ChSasH7DDyLxC33KxZ7faXBDPZtTDdkhtQBAPHM5/kYIEXChpr2vJqpbsxJKfKOkEgQEcB7g29l1GhEIrw8NtxhgZalUSBtUn7g7vKHRMZ8LW2bHBkxHsZ5YfeNwlLEVV6FIBjRb3HO7wKDt9TUtWeXRde2doUwbNJEih5eECMt59uDNWw1Rly6eKYkZ/IwIK8IXpFCAXUIjejgtnD1i+E2ZBq8701CMu74JCp3J9KDvQVbbRactKlsCACMrdJCEKndDZjroO24lcW59LnSxrIOybBqZBsGi1b2KfMAjw2nAZHIDKHz5LEoeG6RIu6tghDMYox9wI87FWrTSeeS06n1cfcXALOmgmB7MaKsX9PkOfREp/f9WXy6u8FXpAb92lQAvyVFADYnQQdejFZnmMitU9cr7ggGlrGzqAM6bTAgk+maOaqfJeZRU39OIIDa2hLqeIH1l1KlWcfsp90+1A55NeOoMWA116Sf/9NE920oorZ8K/qB9Lqe4o9nio7ziHqrS8fTaJ/0KB7ljsvyZ0DfYDmJKcuWQ/bZdCo9BGoI9zBYe1YmdrJbv3x5qoLEIQw5Q2BzfRDqjiHXSqbwdpQKN9Mzvzz9NXf20ki6cKZ58oNO3Zm7AQAsFh3hXVR38Yb51QUVa7joPFJqrI7kCB9mwBsWTegBycF1/L2t3exLINEOWJl8+ez979+z1U2kBTjGN3A2v7LVRRbQFZgKxFwXfLhtH7nUl4HtXcYKIUTBRM8BXqM+qTOaxgDTqhIksRpOFsQRpSLk7lxf8zjSfLSSrGgNrpfc2zdJTvoPH4NLOFuwu2cOtWA0lCl2eLtGi1jun3haDb5LfM88fBWLX4Z/3YjUL9um0o66+m0X05MkJtZISvD0SAS8WsSrjzrrhY4TmH+i5M/VIx4DeHAKwI3tkkdK+t3sHsMEDTsvfW0WZseLBJCVdgcgEOTeqghK+MjLA+MsIWILwFNmkMgo4LAAA=";
    public static final String PROPERTY$ENTRY_BOOKS_REPORTS_PERIOD_SEARCH_PANEL0 = "$EntryBooksReportsPeriodSearchPanel0";
    public static final String PROPERTY$JCOMBO_BOX0 = "$JComboBox0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(EntryBooksReportsView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected EnumEditor DocumentEditor;
    protected JLabel amountCreditLabel;
    protected JLabel amountDebitLabel;
    protected JLabel amountSoldeLabel;
    protected JButton back;
    protected JLabel entryBookSelectorLabel;
    protected EntryBooksReportsViewHandler handler;
    protected EntryBookComboBoxModel modelEntryBook;
    protected EntryBooksReportsTableModel modelTable;
    protected JButton next;
    protected JComboBox periodComboBox;
    protected Boolean selectedRow;
    protected JLabel soldeLabel;
    protected EntryBooksReportsTable table;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EntryBooksReportsView $Table0 = this;
    private Table $Table1;
    private EntryBooksReportsPeriodSearchPanel $EntryBooksReportsPeriodSearchPanel0;
    private JComboBox $JComboBox0;
    private JButton $JButton0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table2;
    private JLabel $JLabel0;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    EntryBooksReportsPeriodSearchPanel periodSearchPanel;
    EntryBookComboBox comboBox;
    
        
        void $afterCompleteSetup() {
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntryBooksReportsView() {
        $initialize();
    }

    public EntryBooksReportsView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createDocument();
    }

    public void doActionPerformed__on__back(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        comboBox.back();
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        comboBox.next();
    }

    public void doActionPerformed__on__periodComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        periodSearchPanel.refresh(ComboBoxDatesEnum.valueOfDescription((String) periodComboBox.getSelectedItem()));                     validate(); repaint();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAmountCreditLabel() {
        return amountCreditLabel;
    }

    public JLabel getAmountDebitLabel() {
        return amountDebitLabel;
    }

    public JLabel getAmountSoldeLabel() {
        return amountSoldeLabel;
    }

    public JButton getBack() {
        return back;
    }

    public EnumEditor getDocumentEditor() {
        return DocumentEditor;
    }

    public JLabel getEntryBookSelectorLabel() {
        return entryBookSelectorLabel;
    }

    public EntryBooksReportsViewHandler getHandler() {
        return handler;
    }

    public EntryBookComboBoxModel getModelEntryBook() {
        return modelEntryBook;
    }

    public EntryBooksReportsTableModel getModelTable() {
        return modelTable;
    }

    public JButton getNext() {
        return next;
    }

    public JComboBox getPeriodComboBox() {
        return periodComboBox;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JLabel getSoldeLabel() {
        return soldeLabel;
    }

    public EntryBooksReportsTable getTable() {
        return table;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$EntryBooksReportsPeriodSearchPanel0(EntryBooksReportsPeriodSearchPanel $EntryBooksReportsPeriodSearchPanel0) {
        EntryBooksReportsPeriodSearchPanel oldValue = this.$EntryBooksReportsPeriodSearchPanel0;
        this.$EntryBooksReportsPeriodSearchPanel0 = $EntryBooksReportsPeriodSearchPanel0;
        firePropertyChange(PROPERTY$ENTRY_BOOKS_REPORTS_PERIOD_SEARCH_PANEL0, oldValue, $EntryBooksReportsPeriodSearchPanel0);
    }

    public void set$JComboBox0(JComboBox $JComboBox0) {
        JComboBox oldValue = this.$JComboBox0;
        this.$JComboBox0 = $JComboBox0;
        firePropertyChange(PROPERTY$JCOMBO_BOX0, oldValue, $JComboBox0);
    }

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(EntryBooksReportsViewHandler handler) {
        EntryBooksReportsViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setPeriodComboBox(JComboBox periodComboBox) {
        JComboBox oldValue = this.periodComboBox;
        this.periodComboBox = periodComboBox;
        firePropertyChange(PROPERTY_PERIOD_COMBO_BOX, oldValue, periodComboBox);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table1() {
        return $Table1;
    }

    protected EntryBooksReportsPeriodSearchPanel get$EntryBooksReportsPeriodSearchPanel0() {
        return $EntryBooksReportsPeriodSearchPanel0;
    }

    protected JComboBox get$JComboBox0() {
        return $JComboBox0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAmountCreditLabel() {
        $objectMap.put("amountCreditLabel", amountCreditLabel = new JLabel());
        
        amountCreditLabel.setName("amountCreditLabel");
    }

    protected void createAmountDebitLabel() {
        $objectMap.put("amountDebitLabel", amountDebitLabel = new JLabel());
        
        amountDebitLabel.setName("amountDebitLabel");
    }

    protected void createAmountSoldeLabel() {
        $objectMap.put("amountSoldeLabel", amountSoldeLabel = new JLabel());
        
        amountSoldeLabel.setName("amountSoldeLabel");
    }

    protected void createBack() {
        $objectMap.put("back", back = new JButton());
        
        back.setName("back");
        back.setText(_("lima.common.buttonback"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createDocumentEditor() {
        $objectMap.put("DocumentEditor", DocumentEditor = new EnumEditor(org.chorem.lima.business.utils.FormatsEnum.class));
        
        DocumentEditor.setName("DocumentEditor");
    }

    protected void createEntryBookSelectorLabel() {
        $objectMap.put("entryBookSelectorLabel", entryBookSelectorLabel = new JLabel());
        
        entryBookSelectorLabel.setName("entryBookSelectorLabel");
        entryBookSelectorLabel.setText(_("lima.common.entrybook"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new EntryBooksReportsViewHandler(this));
    }

    protected void createModelEntryBook() {
        $objectMap.put("modelEntryBook", modelEntryBook = new EntryBookComboBoxModel());
    }

    protected void createModelTable() {
        $objectMap.put("modelTable", modelTable = new EntryBooksReportsTableModel());
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setText(_("lima.common.buttonnext"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createPeriodComboBox() {
        $objectMap.put("periodComboBox", periodComboBox = new JComboBox(ComboBoxDatesEnum.descriptions()));
        
        periodComboBox.setName("periodComboBox");
        periodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__periodComboBox"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSoldeLabel() {
        $objectMap.put("soldeLabel", soldeLabel = new JLabel());
        
        soldeLabel.setName("soldeLabel");
        soldeLabel.setText(_("lima.common.solde"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new EntryBooksReportsTable(getHandler(), getModelTable()));
        
        table.setName("table");
        table.setRowHeight(24);
        table.setSortable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(entryBookSelectorLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JComboBox0, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(back, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(next, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(DocumentEditor, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 7, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table2, new GridBagConstraints(0, 2, 7, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(periodComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($EntryBooksReportsPeriodSearchPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(table);
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountDebitLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountCreditLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(soldeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountSoldeLabel, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 2 property setters
        table.setModel(getModelTable());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        createModelEntryBook();
        createModelTable();
        periodSearchPanel = new EntryBooksReportsPeriodSearchPanel(handler);
        comboBox = new EntryBookComboBox(handler);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createPeriodComboBox();
        // inline creation of $EntryBooksReportsPeriodSearchPanel0
        $objectMap.put("$EntryBooksReportsPeriodSearchPanel0", $EntryBooksReportsPeriodSearchPanel0 = periodSearchPanel);
        
        $EntryBooksReportsPeriodSearchPanel0.setName("$EntryBooksReportsPeriodSearchPanel0");
        createEntryBookSelectorLabel();
        // inline creation of $JComboBox0
        $objectMap.put("$JComboBox0", $JComboBox0 = comboBox);
        
        $JComboBox0.setName("$JComboBox0");
        createBack();
        createNext();
        createDocumentEditor();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.ok"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getTable().getSelectionModel());
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.amountdebit"));
        createAmountDebitLabel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.amountcredit"));
        createAmountCreditLabel();
        createSoldeLabel();
        createAmountSoldeLabel();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}