/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.opening;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.entity.FiscalPeriodImpl;
import org.chorem.lima.enums.AccountsChartEnum;
import org.chorem.lima.enums.EntryBooksChartEnum;
import org.chorem.lima.enums.FinancialStatementsChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.enums.VatStatementsChartEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.identity.IdentityHandler;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.ui.opening.CreateAccountsPanel;
import org.chorem.lima.ui.opening.CreateEntryBookPanel;
import org.chorem.lima.ui.opening.CreateFiscalPeriodPanel;
import org.chorem.lima.ui.opening.CreateIdentityPanel;
import org.chorem.lima.ui.opening.OpeningView;
import org.nuiton.i18n.I18n;

public class OpeningViewHandler {
    private static final Log log = LogFactory.getLog(OpeningViewHandler.class);
    private static Border noBorder = new EmptyBorder(0, 0, 0, 0);
    private static Color green = new Color(102, 204, 0);
    protected int step;
    protected OpeningView view;
    private CreateAccountsPanel caPanel;
    private CreateIdentityPanel idPanel;
    private CreateEntryBookPanel ebPanel;
    private CreateFiscalPeriodPanel fsPanel;

    public OpeningViewHandler(OpeningView view) {
        this.view = view;
        this.caPanel = new CreateAccountsPanel();
        this.idPanel = new CreateIdentityPanel();
        this.ebPanel = new CreateEntryBookPanel();
        this.fsPanel = new CreateFiscalPeriodPanel();
        this.step = 0;
    }

    public void importSave() {
        ImportExport importExport = new ImportExport(this.view);
        importExport.importExport(ImportExportEnum.CSV_ALL_IMPORT, "", true);
        this.view.dispose();
    }

    /*
     * Unable to fully structure code
     */
    public void next() {
        importExport = ImportExport.getInstance(this.view);
        panel = this.view.getPanel();
        panel.removeAll();
        switch (this.step) {
            case 0: {
                this.view.getIdentityIcon().setBorder(BorderFactory.createLineBorder(OpeningViewHandler.green, 2));
                panel.add(this.idPanel);
                panel.validate();
                this.view.repaint();
                ++this.step;
                break;
            }
            case 1: {
                identityHandler = new IdentityHandler();
                identityHandler.updateIdentity(this.idPanel.getIdentity());
                this.view.getIdentityIcon().setBorder(OpeningViewHandler.noBorder);
                this.view.getAccountsIcon().setBorder(BorderFactory.createLineBorder(OpeningViewHandler.green, 2));
                panel.add(this.caPanel);
                panel.validate();
                this.view.repaint();
                ++this.step;
                break;
            }
            case 2: {
                value = this.caPanel.getRadioButtons().getSelectedValue();
                if (value != null) {
                    defaultAccountsChartEnum = (AccountsChartEnum)value;
                    switch (1.$SwitchMap$org$chorem$lima$enums$AccountsChartEnum[defaultAccountsChartEnum.ordinal()]) {
                        case 1: {
                            importExport.importExport(ImportExportEnum.EBP_ACCOUNTCHARTS_IMPORT, defaultAccountsChartEnum.getFilePath(), false);
                            break;
                        }
                        default: {
                            importExport.importExport(ImportExportEnum.CSV_ACCOUNTCHARTS_IMPORT, defaultAccountsChartEnum.getFilePath(), false);
                        }
                    }
                    switch (1.$SwitchMap$org$chorem$lima$enums$AccountsChartEnum[defaultAccountsChartEnum.ordinal()]) {
                        case 2: {
                            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT, FinancialStatementsChartEnum.SHORTENED.getFilePath(), false);
                            break;
                        }
                        case 3: {
                            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT, FinancialStatementsChartEnum.DEVELOPED.getFilePath(), false);
                            break;
                        }
                        default: {
                            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT, FinancialStatementsChartEnum.BASE.getFilePath(), false);
                        }
                    }
                    switch (1.$SwitchMap$org$chorem$lima$enums$AccountsChartEnum[defaultAccountsChartEnum.ordinal()]) {
                        case 2: {
                            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT, VatStatementsChartEnum.SHORTENED.getFilePath(), false);
                            break;
                        }
                        case 4: {
                            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT, VatStatementsChartEnum.BASE.getFilePath(), false);
                            break;
                        }
                        case 3: {
                            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT, VatStatementsChartEnum.DEVELOPED.getFilePath(), false);
                            break;
                        }
                        default: {
                            importExport.importExport(ImportExportEnum.CSV_VAT_IMPORT, VatStatementsChartEnum.DEFAULT.getFilePath(), false);
                        }
                    }
                }
                this.view.getAccountsIcon().setBorder(OpeningViewHandler.noBorder);
                this.view.getEntrybooksIcon().setBorder(BorderFactory.createLineBorder(OpeningViewHandler.green, 2));
                panel.add(this.ebPanel);
                panel.validate();
                this.view.repaint();
                ++this.step;
                break;
            }
            case 3: {
                if (this.ebPanel.getImportEntryBook().isSelected()) {
                    importExport.importExport(ImportExportEnum.CSV_ENTRYBOOKS_IMPORT, EntryBooksChartEnum.DEFAULT.getFilePath(), false);
                }
                this.view.getEntrybooksIcon().setBorder(OpeningViewHandler.noBorder);
                this.view.getFiscalperiodsIcon().setBorder(BorderFactory.createLineBorder(OpeningViewHandler.green, 2));
                panel.add(this.fsPanel);
                panel.validate();
                this.view.getOk().setText(I18n._((String)"lima.common.fin", (Object[])new Object[0]));
                this.view.repaint();
                ++this.step;
                break;
            }
            case 4: {
                try {
                    fiscalPeriod = new FiscalPeriodImpl();
                    fiscalPeriod.setBeginDate(this.fsPanel.getBeginDatePicker().getDate());
                    fiscalPeriod.setEndDate(this.fsPanel.getEndDatePicker().getDate());
                    LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class).createFiscalPeriod((FiscalPeriod)fiscalPeriod);
                }
                catch (LimaException ex) {
                    if (!OpeningViewHandler.log.isErrorEnabled()) ** GOTO lbl85
                    OpeningViewHandler.log.error((Object)"Can't create fiscal period", (Throwable)ex);
                }
lbl85:
                // 3 sources

                this.view.dispose();
            }
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$chorem$lima$enums$AccountsChartEnum;

        static {
            $SwitchMap$org$chorem$lima$enums$AccountsChartEnum = new int[AccountsChartEnum.values().length];
            try {
                1.$SwitchMap$org$chorem$lima$enums$AccountsChartEnum[AccountsChartEnum.IMPORTEBP.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$chorem$lima$enums$AccountsChartEnum[AccountsChartEnum.SHORTENED.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$chorem$lima$enums$AccountsChartEnum[AccountsChartEnum.DEVELOPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$chorem$lima$enums$AccountsChartEnum[AccountsChartEnum.BASE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

