/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.lettering;

import java.awt.Component;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.lettering.AddLetterForm;
import org.chorem.lima.ui.lettering.LetteringTable;
import org.chorem.lima.ui.lettering.LetteringTableModel;
import org.chorem.lima.ui.lettering.LetteringView;
import org.chorem.lima.util.DialogHelper;
import org.nuiton.i18n.I18n;

public class LetteringViewHandler {
    private static final Log log = LogFactory.getLog(LetteringViewHandler.class);
    protected LetteringView view;
    protected LetteringTable table;
    protected LetteringTableModel tableModel;
    protected FiscalPeriodComboBoxModel fiscalPeriodComboBoxModel;
    protected FinancialPeriodComboBoxModel financialPeriodComboBoxModel;
    protected final FinancialTransactionServiceMonitorable financialTransactionService;
    protected Object clipBoard;

    protected LetteringViewHandler(LetteringView view) {
        this.view = view;
        this.financialTransactionService = LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);
    }

    public void setBeginDate(Date date) {
        this.tableModel = this.view.getTableModel();
        this.tableModel.setSelectedBeginDate(date);
    }

    public void setEndDate(Date date) {
        this.tableModel = this.view.getTableModel();
        this.tableModel.setSelectedEndDate(date);
    }

    public void addLetter() {
        Letter letter = null;
        Boolean valid = true;
        this.table = this.view.getTable();
        this.tableModel = this.view.getTableModel();
        AddLetterForm addLetterForm = new AddLetterForm();
        JTextField newLetterTextField = addLetterForm.getNewLetterTextField();
        try {
            letter = this.financialTransactionService.getNewLetter();
            newLetterTextField.setText(letter.getCode());
        }
        catch (LimaException eee) {
            log.error((Object)"Can't get new letter", (Throwable)eee);
        }
        addLetterForm.setLocationRelativeTo((Component)((Object)this.view));
        addLetterForm.setVisible(true);
        if (addLetterForm.validOk.booleanValue()) {
            Object object = addLetterForm.getRadioButtons().getSelectedValue();
            if (!((Boolean)object).booleanValue()) {
                JComboBox comboBox = addLetterForm.getLetterListComboBox();
                Object selectedObject = comboBox.getSelectedItem();
                if (selectedObject instanceof Letter) {
                    letter = (Letter)selectedObject;
                } else {
                    DialogHelper.showMessageDialog(I18n._((String)"lima.entries.lettering.noletterselected", (Object[])new Object[0]));
                    valid = false;
                }
            }
            if (valid.booleanValue()) {
                int[] rows;
                for (int i : rows = this.table.getSelectedRows()) {
                    this.tableModel.setLetter(i, letter);
                }
                this.tableModel.refresh();
            }
        }
    }

    public void removeLetter() {
        int[] rows;
        this.table = this.view.getTable();
        this.tableModel = this.view.getTableModel();
        for (int i : rows = this.table.getSelectedRows()) {
            this.tableModel.removeLetter(i);
        }
        this.tableModel.refresh();
    }

    public void refresh() {
        this.tableModel = this.view.getTableModel();
        this.tableModel.refresh();
    }
}

