/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.importexport;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ExportServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.utils.ImportExportEntityEnum;
import org.chorem.lima.enums.EncodingEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.account.AccountViewHandler;
import org.chorem.lima.ui.importexport.ImportExportWaitView;
import org.chorem.lima.util.DialogHelper;
import org.jdesktop.swingx.painter.BusyPainter;
import org.nuiton.i18n.I18n;

public class ImportExport {
    private static ImportExport exchanger;
    private static final Log log;
    protected static Component viewComponent;
    protected EncodingEnum encodingEnum;
    protected ImportServiceMonitorable importService;
    protected ExportServiceMonitorable exportService;
    private ImportExportWaitView waitView;

    public ImportExport(Component view) {
        viewComponent = view;
        this.importService = LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class);
        this.exportService = LimaServiceFactory.getInstance().getService(ExportServiceMonitorable.class);
        this.waitView = new ImportExportWaitView();
        this.waitView.waitDialog.setSize(400, 200);
        this.waitView.setLocationRelativeTo(view);
        BusyPainter busyPainter = this.waitView.getBusylabel().getBusyPainter();
        busyPainter.setHighlightColor(new Color(44, 61, 146).darker());
        busyPainter.setBaseColor(new Color(168, 204, 241).brighter());
    }

    public void importExport(ImportExportEnum importExportMethode, String file, Boolean verbose) {
        final ImportExportEnum importExportMethodeF = importExportMethode;
        this.encodingEnum = EncodingEnum.UTF8;
        if (file.equals("")) {
            file = this.chooseFile(importExportMethode.getImportMode(), importExportMethode);
        }
        if (!file.equals("")) {
            final EncodingEnum charset = this.encodingEnum;
            final String filePath = file;
            final Boolean verboseMode = verbose;
            final Boolean importMode = importExportMethode.getImportMode();
            new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() throws LimaException {
                    String datas = "";
                    String result = "";
                    switch (importExportMethodeF) {
                        case CSV_ALL_EXPORT: {
                            datas = ImportExport.this.exportService.exportAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case CSV_ACCOUNTCHARTS_EXPORT: {
                            datas = ImportExport.this.exportService.exportAccountsChartAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case CSV_ENTRYBOOKS_EXPORT: {
                            datas = ImportExport.this.exportService.exportEntryBookChartAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case CSV_FINANCIALSTATEMENTS_EXPORT: {
                            datas = ImportExport.this.exportService.exportFinancialStatementChartAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case CSV_VAT_EXPORT: {
                            datas = ImportExport.this.exportService.exportVatStatementChartAsCSV();
                            ImportExport.this.createFile(filePath, charset.getEncoding(), datas);
                            break;
                        }
                        case EBP_ACCOUNTCHARTS_EXPORT: {
                            datas = ImportExport.this.exportService.exportAccountsAsEBP();
                            ImportExport.this.createFile(filePath, EncodingEnum.ISOLATIN1.getEncoding(), datas);
                            break;
                        }
                        case EBP_ENTRIES_EXPORT: {
                            datas = ImportExport.this.exportService.exportEntriesAsEBP();
                            ImportExport.this.createFile(filePath, EncodingEnum.ISOLATIN1.getEncoding(), datas);
                            break;
                        }
                        case CSV_ALL_IMPORT: {
                            datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAllAsCSV(datas);
                            break;
                        }
                        case CSV_ACCOUNTCHARTS_IMPORT: {
                            datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsCSV(datas, ImportExportEntityEnum.ACCOUNT);
                            break;
                        }
                        case CSV_ENTRYBOOKS_IMPORT: {
                            datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsCSV(datas, ImportExportEntityEnum.ENTRYBOOK);
                            break;
                        }
                        case CSV_FINANCIALSTATEMENTS_IMPORT: {
                            datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsCSV(datas, ImportExportEntityEnum.FINANCIALSTATEMENT);
                            break;
                        }
                        case CSV_VAT_IMPORT: {
                            datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsCSV(datas, ImportExportEntityEnum.VATSTATEMENT);
                            break;
                        }
                        case PDF_VAT_IMPORT: {
                            int response = JOptionPane.showConfirmDialog(ImportExport.this.waitView, I18n._((String)"lima.importexport.usevatpdf", (Object[])new Object[0]), I18n._((String)"lima.common.confirmation", (Object[])new Object[0]), 0);
                            datas = ImportExport.this.extractFile(filePath, charset.getEncoding());
                            result = ImportExport.this.importService.importAsPDF(filePath, ImportExportEntityEnum.VATPDF, response == 0);
                            break;
                        }
                        case EBP_ACCOUNTCHARTS_IMPORT: {
                            datas = ImportExport.this.extractFile(filePath, EncodingEnum.ISOLATIN1.getEncoding());
                            result = ImportExport.this.importService.importAccountsChartFromEbp(datas);
                            break;
                        }
                        case EBP_ENTRIES_IMPORT: {
                            datas = ImportExport.this.extractFile(filePath, EncodingEnum.ISOLATIN1.getEncoding());
                            result = ImportExport.this.importService.importEntriesFromEbp(datas);
                        }
                    }
                    return result;
                }

                @Override
                protected void done() {
                    block11: {
                        try {
                            ImportExport.this.waitView.setVisible(false);
                            if (verboseMode.booleanValue()) {
                                String result = (String)this.get();
                                if (!result.equals("")) {
                                    DialogHelper.showReportDialog(result, I18n._((String)"lima.importexport.import", (Object[])new Object[0]), viewComponent);
                                } else if (importMode.booleanValue()) {
                                    if (importExportMethodeF.equals((Object)ImportExportEnum.PDF_VAT_IMPORT)) {
                                        JOptionPane.showMessageDialog(ImportExport.this.waitView, I18n._((String)"lima.importexport.import.vatpdfimport", (Object[])new Object[0]), I18n._((String)"lima.importexport.import", (Object[])new Object[0]), 1);
                                    } else {
                                        JOptionPane.showMessageDialog(ImportExport.this.waitView, I18n._((String)"lima.importexport.import.terminated", (Object[])new Object[0]), I18n._((String)"lima.importexport.import", (Object[])new Object[0]), 1);
                                    }
                                } else {
                                    JOptionPane.showMessageDialog(ImportExport.this.waitView, I18n._((String)"lima.importexport.export.terminated", (Object[])new Object[0]), I18n._((String)"lima.importexport.export", (Object[])new Object[0]), 1);
                                }
                            }
                        }
                        catch (InterruptedException eee) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"Can't get result message", (Throwable)eee);
                            }
                        }
                        catch (ExecutionException eee) {
                            DialogHelper.showMessageDialog(eee.getCause().getMessage());
                            if (!log.isErrorEnabled()) break block11;
                            log.error((Object)"Error on import", (Throwable)eee);
                        }
                    }
                }
            }.execute();
            this.waitView.setVisible(true);
        }
    }

    public String chooseFile(Boolean importMode, ImportExportEnum importExportMethode) {
        String filePath = "";
        JFileChooser chooser = new JFileChooser();
        JComboBox<String> comboBox = new JComboBox<String>(EncodingEnum.descriptions());
        if (importExportMethode.getEncodingOption().booleanValue()) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JLabel(I18n._((String)"lima.importexport.choiceencoding", (Object[])new Object[0])), "West");
            panel.add(comboBox, "Center");
            ((Container)chooser.getComponent(2)).add((Component)panel, "South");
        }
        if (importMode.booleanValue()) {
            chooser.setFileSelectionMode(0);
        } else {
            chooser.setFileSelectionMode(1);
        }
        if (chooser.showOpenDialog(viewComponent) == 0) {
            filePath = chooser.getSelectedFile().getAbsolutePath();
            if (importExportMethode.getEncodingOption().booleanValue()) {
                this.encodingEnum = EncodingEnum.valueOfDescription((String)comboBox.getSelectedItem());
            }
        }
        return filePath;
    }

    public void createFile(String filePath, String charset, String datas) {
        block2: {
            try {
                File file = new File(filePath);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
                out.write(datas);
                out.flush();
                out.close();
            }
            catch (IOException eee) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Can't write file " + filePath), (Throwable)eee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String extractFile(String filePath, String charset) {
        StringWriter sw = new StringWriter();
        BufferedReader in = null;
        try {
            InputStream is = null;
            if (filePath != null && filePath.indexOf(".jar!") > 0) {
                String resourcesPath = filePath.substring(filePath.indexOf(".jar!") + 5);
                is = ImportExport.class.getResourceAsStream(resourcesPath);
            } else {
                is = new FileInputStream(filePath);
            }
            in = new BufferedReader(new InputStreamReader(is, charset));
            IOUtils.copy((Reader)in, (Writer)sw);
            in.close();
            IOUtils.closeQuietly((Reader)in);
        }
        catch (IOException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't read file " + filePath), (Throwable)eee);
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return sw.toString();
    }

    public static ImportExport getInstance(Component view) {
        if (exchanger == null) {
            exchanger = new ImportExport(view);
        } else {
            viewComponent = view;
        }
        return exchanger;
    }

    static {
        log = LogFactory.getLog(AccountViewHandler.class);
    }
}

