/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.home;

import java.awt.Color;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.home.HomeView;
import org.nuiton.i18n.I18n;

public class FinancialTransactionsPane
extends JEditorPane
implements HyperlinkListener,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FinancialTransactionsPane.class);
    protected HomeView view;
    protected FinancialTransactionServiceMonitorable financialTransactionService;
    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    private static Color redBackground = new Color(255, 238, 238);
    private static Color greenBackground = new Color(238, 255, 238);

    public FinancialTransactionsPane(HomeView view) {
        this.view = view;
        this.financialTransactionService = LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);
        this.financialTransactionService.addListener((ServiceListener)this);
        this.fiscalPeriodService = LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);
        this.fiscalPeriodService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.setOpaque(true);
        this.setContentType("text/html");
        this.setEditable(false);
        this.setUI(new BasicEditorPaneUI());
        this.addHyperlinkListener(this);
        this.refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e.getDescription().equals("#financialtransactionunbalanced")) {
                MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
                ui.getHandler().showTransactionUnbalancedView((JAXXContext)ui);
            } else if (e.getDescription().equals("#financialtransactionbalanced")) {
                MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
                ui.getHandler().showTransactionView((JAXXContext)ui);
            }
        }
    }

    public void refresh() {
        String htmlBegin = "<font face='sans-serif' size=3><p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        try {
            List unblockedFiscalPeriods = this.fiscalPeriodService.getAllUnblockedFiscalPeriods();
            if (unblockedFiscalPeriods.size() != 0) {
                List financialTransactionsUnbal = this.financialTransactionService.getAllInexactFinancialTransactions((FiscalPeriod)unblockedFiscalPeriods.get(0));
                if (financialTransactionsUnbal.size() > 0) {
                    this.setBackground(redBackground);
                    String transactionsString = financialTransactionsUnbal.size() + " " + I18n._((String)"lima.home.transaction.unbalanced", (Object[])new Object[0]) + "<br/><br/><a href='#financialtransactionunbalanced'>" + I18n._((String)"lima.home.transaction.modifiy.unbalanced", (Object[])new Object[0]) + "</a>";
                    this.setText(htmlBegin + transactionsString + htmlEnd);
                } else {
                    List financialTransactionsBal = this.financialTransactionService.getAllFinancialTransactionsBalanced((FiscalPeriod)unblockedFiscalPeriods.get(0));
                    if (financialTransactionsBal.size() > 0) {
                        this.setBackground(greenBackground);
                        String transactionsString = financialTransactionsBal.size() + " " + I18n._((String)"lima.home.transaction.balanced", (Object[])new Object[0]) + "<br/><br/><a href='#financialtransactionbalanced'>" + I18n._((String)"lima.home.transaction.modifiy.balanced", (Object[])new Object[0]) + "</a>";
                        this.setText(htmlBegin + transactionsString + htmlEnd);
                    } else {
                        this.setBackground(redBackground);
                        String transactionsString = I18n._((String)"lima.home.transaction.nothing", (Object[])new Object[0]) + "<br/><br/><a href='#financialtransactionbalanced'>" + I18n._((String)"lima.home.transaction.create", (Object[])new Object[0]) + "</a>";
                        this.setText(htmlBegin + transactionsString + htmlEnd);
                    }
                }
            } else {
                this.setBackground(redBackground);
            }
        }
        catch (LimaException eee) {
            log.debug((Object)"Can't get datas account editor pane home", (Throwable)eee);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("FiscalPeriod") || methodeName.contains("FinancialTransaction") || methodeName.contains("Entry") || methodeName.contains("importEntries") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.refresh();
        }
    }
}

