/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.fiscalperiod;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryBookImpl;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.fiscalperiod.AddPeriod;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodTable;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodTableModel;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodView;
import org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm;
import org.chorem.lima.util.DialogHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;

public class FiscalPeriodViewHandler {
    private static final Log log = LogFactory.getLog(FiscalPeriodViewHandler.class);
    private FiscalPeriodView view;
    protected FiscalPeriodTable table;
    protected FiscalPeriodTableModel tableModel;
    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    protected FinancialTransactionServiceMonitorable financialTransactionService;

    protected FiscalPeriodViewHandler(FiscalPeriodView view) {
        this.view = view;
        this.fiscalPeriodService = LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);
        this.financialTransactionService = LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);
    }

    public void addFiscalPeriod() {
        FiscalPeriodTableModel model = (FiscalPeriodTableModel)this.getView().getFiscalPeriodTable().getModel();
        AddPeriod addPeriodDialog = new AddPeriod((JAXXContext)this.getView());
        addPeriodDialog.setLocationRelativeTo((Component)((Object)this.getView()));
        addPeriodDialog.setVisible(true);
        FiscalPeriod fiscalPeriod = addPeriodDialog.getPeriod();
        if (fiscalPeriod != null) {
            int nbMonth = DateUtil.getDifferenceInMonths((Date)fiscalPeriod.getBeginDate(), (Date)fiscalPeriod.getEndDate());
            int n = 0;
            if (nbMonth != 12) {
                n = JOptionPane.showConfirmDialog((Component)((Object)this.getView()), I18n._((String)"lima.charts.fiscalperiod.question.morethan12", (Object[])new Object[0]), I18n._((String)"lima.common.question", (Object[])new Object[0]), 0, 3);
            }
            if (n == 0 || nbMonth == 11) {
                try {
                    model.addFiscalPeriod(fiscalPeriod);
                }
                catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't add fiscal period", (Throwable)eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }

    public void blockFiscalPeriod() {
        FiscalPeriodTable fiscalPeriodeTable = this.getView().getFiscalPeriodTable();
        int selectedRow = fiscalPeriodeTable.getSelectedRow();
        FiscalPeriodTableModel model = (FiscalPeriodTableModel)this.getView().getFiscalPeriodTable().getModel();
        try {
            FiscalPeriod selectedFiscalPeriod = model.getFiscalPeriodAtRow(selectedRow);
            int response = JOptionPane.showConfirmDialog((Component)((Object)this.getView()), I18n._((String)"lima.charts.fiscalperiod.question.blocked", (Object[])new Object[0]), I18n._((String)"lima.common.question", (Object[])new Object[0]), 0, 3);
            if (response == 0) {
                boolean newyear = false;
                if (model.getRowCount() - 1 != selectedRow) {
                    newyear = true;
                } else {
                    response = JOptionPane.showConfirmDialog((Component)((Object)this.getView()), I18n._((String)"lima.charts.fiscalperiod.question.newyear", (Object[])new Object[0]), I18n._((String)"lima.common.question", (Object[])new Object[0]), 0, 3);
                    if (response == 0) {
                        this.addFiscalPeriod();
                        newyear = true;
                    }
                }
                this.addRetainedEarnings(selectedFiscalPeriod, newyear);
                model.blockFiscalPeriod(selectedFiscalPeriod);
            }
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't block fiscalperiod", (Throwable)eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }

    public void addRetainedEarnings(FiscalPeriod selectedFiscalPeriod, boolean newyear) {
        FiscalPeriodTable fiscalPeriodeTable = this.getView().getFiscalPeriodTable();
        int selectedRow = fiscalPeriodeTable.getSelectedRow();
        FiscalPeriodTableModel model = (FiscalPeriodTableModel)this.getView().getFiscalPeriodTable().getModel();
        try {
            int response;
            boolean found = false;
            List financialTransactionsList = this.financialTransactionService.getAllFinancialTransactionsFromDateToDate(selectedFiscalPeriod.getBeginDate(), selectedFiscalPeriod.getEndDate());
            if (!financialTransactionsList.isEmpty()) {
                for (int i = 0; i < financialTransactionsList.size() && !found; ++i) {
                    Collection entryList = ((FinancialTransaction)financialTransactionsList.get(i)).getEntry();
                    for (Entry entry : entryList) {
                        if (Integer.valueOf(entry.getAccount().getAccountNumber().substring(0, 1)) >= 6 || entry.getAmount().equals(BigDecimal.ZERO)) continue;
                        found = true;
                    }
                }
            }
            if (found && (response = JOptionPane.showConfirmDialog((Component)((Object)this.getView()), I18n._((String)"lima.charts.fiscalperiod.question.addretainedearnings", (Object[])new Object[0]), I18n._((String)"lima.common.question", (Object[])new Object[0]), 0, 3)) == 0) {
                EntryBookImpl newEntryBook = new EntryBookImpl();
                RetainedEarningsEntryBookForm entryBookForm = new RetainedEarningsEntryBookForm((JAXXContext)this.view);
                entryBookForm.setEntryBook((EntryBook)newEntryBook);
                entryBookForm.setLocationRelativeTo((Component)((Object)this.view));
                entryBookForm.setVisible(true);
                EntryBook entryBook = entryBookForm.getEntryBook();
                if (entryBook != null) {
                    this.fiscalPeriodService.addRetainedEarnings(selectedFiscalPeriod, newyear, entryBook);
                }
            }
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't set net income", (Throwable)eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }

    public FiscalPeriodView getView() {
        return this.view;
    }

    public void refresh() {
        this.tableModel = (FiscalPeriodTableModel)this.getView().getFiscalPeriodTable().getModel();
        this.tableModel.refresh();
    }
}

