/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.fiscalperiod;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.utils.FiscalPeriodComparator;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class FiscalPeriodTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = 77027335135838258L;
    private static final Log log = LogFactory.getLog(FiscalPeriodTableModel.class);
    protected FiscalPeriodServiceMonitorable fiscalPeriodService = LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);
    protected FinancialTransactionServiceMonitorable financialTransactionService;
    protected List<Object> cacheDataList;

    public FiscalPeriodTableModel() {
        this.fiscalPeriodService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.financialTransactionService = LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);
        this.financialTransactionService.addListener((ServiceListener)this);
        this.cacheDataList = null;
    }

    protected List<Object> getDataList() {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            List fiscalPeriod = this.fiscalPeriodService.getAllFiscalPeriods();
            Collections.sort(fiscalPeriod, new FiscalPeriodComparator());
            results.addAll(fiscalPeriod);
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.debug((Object)"Can't update model", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"lima.fiscalperiod.listerror", (Object[])new Object[0]), eee);
        }
        return results;
    }

    public void refresh() {
        this.cacheDataList = this.getDataList();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Object getElementAt(int row) {
        Object currentRow = null;
        if (this.cacheDataList != null) {
            currentRow = this.cacheDataList.get(row);
        }
        return currentRow;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result = "n/a";
        switch (columnIndex) {
            case 0: {
                result = I18n._((String)"lima.table.fiscalperiod", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.closure", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result = "n/a";
        List<Object> periods = this.cacheDataList;
        FiscalPeriod fiscalPeriod = (FiscalPeriod)periods.get(rowIndex);
        if (fiscalPeriod != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy");
            switch (columnIndex) {
                case 0: {
                    result = simpleDateFormat.format(fiscalPeriod.getBeginDate()) + " - " + simpleDateFormat.format(fiscalPeriod.getEndDate());
                    break;
                }
                case 1: {
                    result = fiscalPeriod.getLocked() ? I18n._((String)"lima.common.closed", (Object[])new Object[0]) : I18n._((String)"lima.common.open", (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    public FiscalPeriod getFiscalPeriodAtRow(int row) throws LimaException {
        FiscalPeriod fiscalPeriod = null;
        fiscalPeriod = (FiscalPeriod)this.cacheDataList.get(row);
        return fiscalPeriod;
    }

    public void addFiscalPeriod(FiscalPeriod period) throws LimaException {
        try {
            this.fiscalPeriodService.createFiscalPeriod(period);
            this.cacheDataList = this.getDataList();
            int row = this.getDataList().indexOf(period);
            this.fireTableRowsInserted(row, row);
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.debug((Object)"Can't create FiscalPeriod", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"lima.fiscalperiod.creationerror", (Object[])new Object[0]), eee);
        }
    }

    public void blockFiscalPeriod(FiscalPeriod fiscalPeriod) throws LimaException {
        List financialTransactionsUnbal = this.financialTransactionService.getAllInexactFinancialTransactions(fiscalPeriod);
        if (financialTransactionsUnbal.size() > 0) {
            JFrame f = new JFrame();
            f.setIconImage(Resource.getIcon((String)"icons/lima.png").getImage());
            JOptionPane.showMessageDialog(f, I18n._((String)"lima.fiscalperiod.unbalancedtransactions", (Object[])new Object[0]), I18n._((String)"lima.common.error", (Object[])new Object[0]), 0);
            f.dispose();
        } else {
            this.fiscalPeriodService.blockFiscalPeriod(fiscalPeriod);
            this.refresh();
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

