/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.enums.ComboBoxPeriodEnum;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxRenderer;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxRenderer;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;

public class FinancialTransactionPeriodSearchPanel
extends JPanel {
    private static final Log log = LogFactory.getLog(FinancialTransactionPeriodSearchPanel.class);
    protected FinancialTransactionSearchViewHandler handler;
    static final long serialVersionUID = 1L;

    public FinancialTransactionPeriodSearchPanel(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
        this.refresh(ComboBoxPeriodEnum.PERIOD);
    }

    public void refresh(ComboBoxPeriodEnum comboBoxPeriodEnum) {
        switch (comboBoxPeriodEnum) {
            case DATE: {
                Calendar calendar = Calendar.getInstance();
                Date date = calendar.getTime();
                date = DateUtils.truncate((Date)date, (int)5);
                final JXDatePicker datePicker = new JXDatePicker(date);
                ActionListener dateActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FinancialTransactionPeriodSearchPanel.this.handler.setBeginDate(datePicker.getDate());
                        FinancialTransactionPeriodSearchPanel.this.handler.refresh();
                    }
                };
                this.handler.setBeginDate(datePicker.getDate());
                this.handler.setEndDate(null);
                this.handler.refresh();
                datePicker.addActionListener(dateActionListener);
                this.removeAll();
                this.add((Component)datePicker);
                break;
            }
            case PERIOD: {
                Calendar calendarBegin = Calendar.getInstance();
                Date beginDate = calendarBegin.getTime();
                beginDate = DateUtils.truncate((Date)beginDate, (int)1);
                Calendar calendarEnd = Calendar.getInstance();
                Date endDate = calendarEnd.getTime();
                JLabel beginDateLabel = new JLabel(I18n._((String)"lima.common.begindate", (Object[])new Object[0]));
                final JXDatePicker beginDatePicker = new JXDatePicker(beginDate);
                ActionListener beginDateActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FinancialTransactionPeriodSearchPanel.this.handler.setBeginDate(beginDatePicker.getDate());
                        FinancialTransactionPeriodSearchPanel.this.handler.refresh();
                    }
                };
                this.handler.setBeginDate(beginDatePicker.getDate());
                beginDatePicker.addActionListener(beginDateActionListener);
                JLabel endDateLabel = new JLabel(I18n._((String)"lima.common.enddate", (Object[])new Object[0]));
                final JXDatePicker endDatePicker = new JXDatePicker(endDate);
                ActionListener endDateActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FinancialTransactionPeriodSearchPanel.this.handler.setEndDate(endDatePicker.getDate());
                        FinancialTransactionPeriodSearchPanel.this.handler.refresh();
                    }
                };
                this.handler.setEndDate(endDatePicker.getDate());
                endDatePicker.addActionListener(endDateActionListener);
                this.handler.refresh();
                this.removeAll();
                this.add(beginDateLabel);
                this.add((Component)beginDatePicker);
                this.add(endDateLabel);
                this.add((Component)endDatePicker);
                break;
            }
            case FISCAL_PERIOD: {
                FiscalPeriodComboBoxModel fiscalModel = new FiscalPeriodComboBoxModel();
                FiscalPeriodComboBoxRenderer fiscalRenderer = new FiscalPeriodComboBoxRenderer();
                final JComboBox<Object> fiscalPeriod = new JComboBox<Object>(fiscalModel);
                fiscalPeriod.setRenderer(fiscalRenderer);
                fiscalPeriod.setEditable(false);
                ActionListener fiscalPeriodActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FiscalPeriod fPeriod = (FiscalPeriod)fiscalPeriod.getSelectedItem();
                        FinancialTransactionPeriodSearchPanel.this.handler.setBeginDate(fPeriod.getBeginDate());
                        FinancialTransactionPeriodSearchPanel.this.handler.setEndDate(fPeriod.getEndDate());
                        FinancialTransactionPeriodSearchPanel.this.handler.refresh();
                    }
                };
                fiscalPeriod.addActionListener(fiscalPeriodActionListener);
                this.removeAll();
                this.add(fiscalPeriod);
                break;
            }
            case FINANCIAL_PERIOD: {
                FinancialPeriodComboBoxModel financialModel = new FinancialPeriodComboBoxModel();
                FinancialPeriodComboBoxRenderer financialRenderer = new FinancialPeriodComboBoxRenderer();
                final JComboBox<Object> financialPeriod = new JComboBox<Object>(financialModel);
                financialPeriod.setRenderer(financialRenderer);
                financialPeriod.setEditable(false);
                ActionListener financialPeriodActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FinancialPeriod fPeriod = (FinancialPeriod)financialPeriod.getSelectedItem();
                        FinancialTransactionPeriodSearchPanel.this.handler.setBeginDate(fPeriod.getBeginDate());
                        FinancialTransactionPeriodSearchPanel.this.handler.setEndDate(fPeriod.getEndDate());
                        FinancialTransactionPeriodSearchPanel.this.handler.refresh();
                    }
                };
                financialPeriod.addActionListener(financialPeriodActionListener);
                this.removeAll();
                this.add(financialPeriod);
            }
        }
    }
}

