/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.EmptyCellRenderer;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionViewHandler;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class FinancialTransactionTable
extends JXTable
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 3133690382049594727L;
    private static final Log log = LogFactory.getLog(FinancialTransactionTable.class);
    protected FinancialTransactionViewHandler handler;
    private Highlighter colorTransaction;
    private ColorHighlighter colorBalance;
    private int x_tab;
    private int y_tab;

    public FinancialTransactionTable(FinancialTransactionViewHandler handler) {
        this.handler = handler;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.setDefaultEditor(Date.class, new DateTableCellEditor());
        this.setDefaultEditor(EntryBook.class, new EntryBookTableCellEditor());
        this.setDefaultEditor(Account.class, new AccountTableCellEditor());
        this.setDefaultEditor(BigDecimal.class, new BigDecimalTableCellEditor());
        this.setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
        this.setDefaultRenderer(String.class, new EmptyCellRenderer());
        this.setDefaultRenderer(Account.class, new EmptyCellRenderer());
        this.setDefaultRenderer(EntryBook.class, new EmptyCellRenderer());
        this.addColorTransaction();
        this.addColorNonBalancedTransaction();
    }

    protected void addColorTransaction() {
        if (this.colorTransaction != null) {
            this.removeHighlighter(this.colorTransaction);
        }
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                return adapter.getValueAt(adapter.row, 0) instanceof Date;
            }
        };
        this.colorTransaction = new ColorHighlighter(predicate, new Color(222, 222, 222), null);
        this.addHighlighter(this.colorTransaction);
    }

    protected void addColorNonBalancedTransaction() {
        if (this.colorBalance != null) {
            this.removeHighlighter((Highlighter)this.colorBalance);
        }
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                BigDecimal currentBalance;
                boolean isHighlighted = false;
                Object value = adapter.getValueAt(adapter.row, 8);
                if (value instanceof BigDecimal && (currentBalance = (BigDecimal)value).compareTo(BigDecimal.ZERO) != 0) {
                    isHighlighted = true;
                }
                return isHighlighted;
            }
        };
        this.colorTransaction = new ColorHighlighter(predicate, new Color(255, 198, 209), null);
        this.addHighlighter(this.colorTransaction);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 || e.getKeyCode() == 12 && e.getModifiers() == 2) {
            this.handler.deleteSelectedRow();
        }
        if (e.getKeyCode() == 155 || e.getKeyCode() == 10 && e.getModifiers() == 2) {
            this.handler.addEmptyEntry();
        }
        if (e.getKeyCode() == 67 && e.getModifiers() == 2) {
            this.handler.copyRow();
        }
        if (e.getKeyCode() == 86 && e.getModifiers() == 2) {
            this.handler.pasteRow();
        }
        if (e.getKeyCode() == 9 && e.getModifiers() == 2) {
            this.handler.addFinancialTransaction();
        }
        if (e.getKeyCode() == 27 && !this.isEditing()) {
            this.clearSelection();
        }
        if (e.getKeyChar() == '\t') {
            int max_x = this.getColumnCount();
            int max_y = this.getRowCount();
            this.x_tab = this.getSelectedColumn();
            this.y_tab = this.getSelectedRow();
            Boolean end = true;
            if (this.x_tab < max_x - 1) {
                ++this.x_tab;
            } else {
                this.x_tab = 0;
                ++this.y_tab;
            }
            while (!this.isCellEditable(this.y_tab, this.x_tab) && end.booleanValue()) {
                if (this.x_tab == max_x - 1) {
                    Object object = this.handler.tableModel.getElementAt(this.y_tab);
                    if (object instanceof FinancialTransaction) {
                        FinancialTransaction financialTransaction = (FinancialTransaction)object;
                        if (financialTransaction.getEntry().size() == 0) {
                            this.handler.addEmptyEntry();
                            this.setColumnSelectionInterval(1, 1);
                        }
                    } else {
                        final FinancialTransactionTable table = this;
                        final int y_t = this.y_tab;
                        final int m_t = max_y;
                        new SwingWorker<Void, Void>(){

                            @Override
                            protected Void doInBackground() throws InterruptedException {
                                Thread.sleep(500L);
                                return null;
                            }

                            @Override
                            protected void done() {
                                Object object = FinancialTransactionTable.this.handler.tableModel.getElementAt(FinancialTransactionTable.this.y_tab - 1);
                                FinancialTransaction financialTransaction = null;
                                if (object instanceof Entry) {
                                    financialTransaction = ((Entry)object).getFinancialTransaction();
                                } else if (object instanceof FinancialTransaction) {
                                    financialTransaction = (FinancialTransaction)object;
                                }
                                BigDecimal amountC = financialTransaction.getAmountCredit();
                                BigDecimal amountD = financialTransaction.getAmountDebit();
                                if (amountC == amountD) {
                                    if (y_t == m_t - 1) {
                                        FinancialTransactionTable.this.handler.addFinancialTransaction();
                                        table.setColumnSelectionInterval(0, 0);
                                    }
                                } else {
                                    FinancialTransactionTable.this.handler.addEmptyEntry();
                                    table.setColumnSelectionInterval(1, 1);
                                    FinancialTransactionTable.this.y_tab++;
                                    table.setRowSelectionInterval(FinancialTransactionTable.this.y_tab, FinancialTransactionTable.this.y_tab);
                                    FinancialTransactionTable.this.x_tab = 0;
                                }
                            }
                        }.execute();
                    }
                    end = false;
                    continue;
                }
                if (this.x_tab >= max_x) continue;
                this.setRowSelectionInterval(this.y_tab, this.y_tab);
                this.setColumnSelectionInterval(this.x_tab, this.x_tab);
                ++this.x_tab;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.rowAtPoint(e.getPoint()) == -1) {
            this.clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

